/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.io.File;
import java.io.IOException;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.Config;
import pl.kaszaq.howfastyouaregoing.agile.AgileProject;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectConfiguration;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectDataObserver;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectFactory;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectProvider;
import pl.kaszaq.howfastyouaregoing.agile.IssueData;
import pl.kaszaq.howfastyouaregoing.agile.jira.AgileProjectDataReader;
import pl.kaszaq.howfastyouaregoing.agile.pojo.AgileProjectData;
import pl.kaszaq.howfastyouaregoing.storage.FileStorage;

public class CachingAgileProjectProvider
implements AgileProjectProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CachingAgileProjectProvider.class);
    private static final ZonedDateTime INITIAL_DATE = ZonedDateTime.of(1970, Month.JANUARY.getValue(), 1, 0, 0, 0, 0, ZoneId.systemDefault());
    private final File cacheDirectory;
    private final Set<String> customFieldsNames;
    private final AgileProjectDataReader agileProjectDataReader;
    private final boolean cacheOnly;
    private final FileStorage fileStorage;

    public CachingAgileProjectProvider(File cacheDirectory, Set<String> customFieldsNames, AgileProjectDataReader agileProjectDataReader, Boolean cacheOnly, FileStorage fileStorage) {
        this.cacheDirectory = cacheDirectory;
        this.customFieldsNames = new HashSet<String>(customFieldsNames);
        this.agileProjectDataReader = agileProjectDataReader;
        this.cacheOnly = cacheOnly;
        this.fileStorage = fileStorage;
    }

    @Override
    public Optional<AgileProject> loadProject(String projectId, AgileProjectConfiguration configuration) {
        return this.loadProject(projectId, configuration, null);
    }

    @Override
    public Optional<AgileProject> loadProject(String projectId, AgileProjectConfiguration configuration, AgileProjectDataObserver observer) {
        try {
            Optional<AgileProjectData> projectDataOptional = this.loadProjectFromFile(projectId);
            AgileProjectData projectData = projectDataOptional.orElse(this.createNewEmptyProject(projectId));
            if (!projectData.getCustomFieldsNames().containsAll(this.customFieldsNames)) {
                LOG.info("Noticied different setup of custom fields. Forcing to recreate project.");
                projectData = this.createNewEmptyProject(projectId);
            }
            projectData = this.agileProjectDataReader.updateProject(projectData, (project, progress) -> {
                if (observer != null) {
                    observer.updated(project, progress);
                }
                this.saveProjectToFile(project);
            }, this.cacheOnly);
            return Optional.of(new AgileProjectFactory().createAgileProject(projectData, configuration.getIssueStatusMapping()));
        }
        catch (Throwable ex) {
            LOG.warn("Problem while reading project data of project {}", (Object)projectId, (Object)ex);
            return Optional.empty();
        }
    }

    private AgileProjectData createNewEmptyProject(String projectId) {
        return new AgileProjectData(projectId, INITIAL_DATE, INITIAL_DATE, new HashMap<String, IssueData>(), this.customFieldsNames, null);
    }

    private Optional<AgileProjectData> loadProjectFromFile(String projectId) throws IOException {
        File projectFile = this.getProjectFile(projectId);
        if (projectFile.exists()) {
            try {
                return Optional.of(Config.OBJECT_MAPPER.readValue(this.fileStorage.loadFile(projectFile), AgileProjectData.class));
            }
            catch (Throwable ex) {
                LOG.warn("Problem while reading project {} from file" + projectId, ex);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private File getProjectFile(String projectId) {
        return new File(this.cacheDirectory, projectId + ".json");
    }

    private void saveProjectToFile(AgileProjectData project) {
        try {
            File projectFile = this.getProjectFile(project.getProjectId());
            this.fileStorage.storeFile(projectFile, Config.OBJECT_MAPPER.writeValueAsString((Object)project));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

