/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import pl.kaszaq.howfastyouaregoing.agile.IssueBlockedTransition;
import pl.kaszaq.howfastyouaregoing.agile.IssueData;
import pl.kaszaq.howfastyouaregoing.agile.IssueDataWrapper;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;

public class Issue {
    private final IssueData issueData;
    private final IssueDataWrapper issueDataWrapper;

    Issue(IssueData issueData) {
        this.issueData = issueData;
        this.issueDataWrapper = new IssueDataWrapper(issueData);
    }

    public Duration getDurationInStatuses(String ... statuses) {
        return this.issueDataWrapper.getDurationInStatuses(statuses);
    }

    public boolean isStatusOnDay(LocalDate date, Set<String> statuses) {
        return this.issueDataWrapper.isStatusOnDay(date, statuses);
    }

    public Map<String, Duration> getTimeInStatus() {
        return this.issueDataWrapper.getTimeInStatus();
    }

    public Set<LocalDate> getAllDayBlockedDays() {
        return this.issueDataWrapper.getAllDayBlockedDays();
    }

    public String getPrettyName() {
        return this.issueData.getPrettyName();
    }

    public String getKey() {
        return this.issueData.getKey();
    }

    public String getCreator() {
        return this.issueData.getCreator();
    }

    public String getType() {
        return this.issueData.getType();
    }

    public String getResolution() {
        return this.issueData.getResolution();
    }

    public String getStatus() {
        return this.issueData.getStatus();
    }

    public String getSummary() {
        return this.issueData.getSummary();
    }

    public String getDescription() {
        return this.issueData.getDescription();
    }

    public ZonedDateTime getCreated() {
        return this.issueData.getCreated();
    }

    public ZonedDateTime getUpdated() {
        return this.issueData.getUpdated();
    }

    public boolean isSubtask() {
        return this.issueData.isSubtask();
    }

    public String getParentIssueKey() {
        return this.issueData.getParentIssueKey();
    }

    public List<String> getSubtaskKeys() {
        return this.issueData.getSubtaskKeys();
    }

    public List<String> getLinkedIssuesKeys() {
        return this.issueData.getLinkedIssuesKeys();
    }

    public List<String> getLabels() {
        return this.issueData.getLabels();
    }

    public List<String> getComponents() {
        return this.issueData.getComponents();
    }

    public TreeSet<IssueStatusTransition> getIssueStatusTransitions() {
        return this.issueData.getIssueStatusTransitions();
    }

    public TreeSet<IssueBlockedTransition> getIssueBlockedTransitions() {
        return this.issueData.getIssueBlockedTransitions();
    }

    public Map<String, Object> getCustomFields() {
        return this.issueData.getCustomFields();
    }

    public String toString() {
        return this.getPrettyName();
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.issueData);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Issue other = (Issue)obj;
        return Objects.equals(this.issueData, other.issueData);
    }
}

