/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile.grouping;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import pl.kaszaq.howfastyouaregoing.agile.AgileProject;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.grouping.IssueHierarchyNode;

public class IssueHierarchyNodeProvider {
    Map<Issue, IssueHierarchyNode> issuesHierarchyNodes = new HashMap<Issue, IssueHierarchyNode>();
    List<Set<AgileProject>> agileProjectsGroupingOrder;
    Map<AgileProject, Set<AgileProject>> agileParentWithCurrentProjects;
    private final Set<AgileProject> allProjects;

    public IssueHierarchyNodeProvider(List<Set<AgileProject>> agileProjectsGroupingOrder) {
        this.agileProjectsGroupingOrder = agileProjectsGroupingOrder;
        this.agileParentWithCurrentProjects = new HashMap<AgileProject, Set<AgileProject>>(agileProjectsGroupingOrder.size());
        for (int i = 0; i < agileProjectsGroupingOrder.size(); ++i) {
            Set parentProjects = agileProjectsGroupingOrder.subList(i + 1, agileProjectsGroupingOrder.size()).stream().flatMap(set -> set.stream()).collect(Collectors.toSet());
            Set<AgileProject> currentProjects = agileProjectsGroupingOrder.get(i);
            currentProjects.forEach(project -> {
                HashSet<AgileProject> parentProjectsWithCurrent = new HashSet<AgileProject>(parentProjects);
                parentProjectsWithCurrent.add((AgileProject)project);
                this.agileParentWithCurrentProjects.put((AgileProject)project, (Set<AgileProject>)parentProjectsWithCurrent);
            });
        }
        this.allProjects = agileProjectsGroupingOrder.stream().flatMap(set -> set.stream()).collect(Collectors.toSet());
    }

    public IssueHierarchyNode getHierarchy(Issue issue) {
        return this.issuesHierarchyNodes.computeIfAbsent(issue, i -> {
            IssueHierarchyNode node = this.createHierarchyNode((Issue)i);
            this.reduce(node);
            return node;
        });
    }

    private IssueHierarchyNode createHierarchyNode(Issue issue) {
        Set<Issue> directlyRelatedIssues = this.getDirectlyParentRelatedIssues(issue);
        IssueHierarchyNode node = new IssueHierarchyNode(issue);
        directlyRelatedIssues.forEach(directlyRelatedIssue -> node.link(this.createHierarchyNode((Issue)directlyRelatedIssue)));
        return node;
    }

    private Set<Issue> getDirectlyParentRelatedIssues(Issue issue) {
        HashSet<Issue> directlyRelatedIssues = new HashSet<Issue>();
        Set<AgileProject> projectsSet = this.getParentAndCurrentProjects(issue);
        projectsSet.forEach(agileProject -> {
            if (agileProject.contains(issue)) {
                this.checkParentIssue(issue, (AgileProject)agileProject).ifPresent(i -> directlyRelatedIssues.add((Issue)i));
                this.checkEpic(issue, (AgileProject)agileProject).ifPresent(i -> directlyRelatedIssues.add((Issue)i));
            } else {
                this.checkLinkedIssues(issue, (AgileProject)agileProject).ifPresent(issues -> directlyRelatedIssues.addAll((Collection<Issue>)issues));
            }
        });
        return directlyRelatedIssues;
    }

    private Optional<Issue> checkParentIssue(Issue issue, AgileProject agileProject) {
        return Optional.of(issue).map(Issue::getParentIssueKey).map(key -> agileProject.getIssue((String)key));
    }

    private Optional<Issue> checkEpic(Issue issue, AgileProject agileProject) {
        return Optional.empty();
    }

    private Optional<Set<Issue>> checkLinkedIssues(Issue issue, AgileProject agileProject) {
        List<String> issueLinks = issue.getLinkedIssuesKeys();
        if (issueLinks != null) {
            return Optional.of(issueLinks.stream().filter(key -> agileProject.contains((String)key)).map(issueId -> agileProject.getIssue((String)issueId)).collect(Collectors.toSet()));
        }
        return Optional.empty();
    }

    private Set<AgileProject> getParentAndCurrentProjects(Issue issue) {
        AgileProject issueAgileProject = this.getIssueProject(issue);
        return this.agileParentWithCurrentProjects.get(issueAgileProject);
    }

    private AgileProject getIssueProject(Issue issue) {
        return this.allProjects.stream().filter(project -> project.contains(issue)).findFirst().get();
    }

    private void reduce(IssueHierarchyNode node) {
        Iterator<IssueHierarchyNode> childNodesIterator = node.getChildNodes().iterator();
        while (childNodesIterator.hasNext()) {
            IssueHierarchyNode childNode = childNodesIterator.next();
            if (!node.getChildNodes().stream().filter(n -> n.hasChild(childNode.getIssue())).findFirst().isPresent()) continue;
            childNodesIterator.remove();
        }
        node.getChildNodes().forEach(n -> this.reduce((IssueHierarchyNode)n));
    }
}

