/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile.jira;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.Config;
import pl.kaszaq.howfastyouaregoing.agile.IssueBlockedTransition;
import pl.kaszaq.howfastyouaregoing.agile.IssueData;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;
import pl.kaszaq.howfastyouaregoing.json.JsonNodeOptional;
import pl.kaszaq.howfastyouaregoing.utils.DateUtils;

class JiraIssueParser {
    private static final Logger LOG = LoggerFactory.getLogger(JiraIssueParser.class);
    private final Map<String, Function<JsonNodeOptional, Object>> customFieldsParsers;

    IssueData parseJiraIssue(String jsonIssue, boolean emptyDescriptionAndSummary) throws IOException {
        JsonNode node = Config.OBJECT_MAPPER.readTree(jsonIssue);
        return this.parseJiraIssue(node, emptyDescriptionAndSummary);
    }

    IssueData parseJiraIssue(JsonNode node, boolean emptyDescriptionAndSummary) {
        String description;
        String summary;
        JsonNodeOptional issueNode = JsonNodeOptional.of(node);
        String key = issueNode.get("key").asText();
        LOG.debug("Parsing issue {}", (Object)key);
        JsonNodeOptional fieldsNode = issueNode.get("fields");
        String creator = fieldsNode.get("creator").get("name").asText();
        ZonedDateTime created = DateUtils.parseDate(fieldsNode.get("created").asText());
        ZonedDateTime updated = DateUtils.parseDate(fieldsNode.get("updated").asText());
        String status = fieldsNode.get("status").get("name").asText();
        if (emptyDescriptionAndSummary) {
            summary = "";
            description = "";
        } else {
            summary = fieldsNode.get("summary").asText();
            description = fieldsNode.get("description").asText();
        }
        TreeSet<IssueStatusTransition> issueStatusTransitions = this.getIssueStatusTransitions(issueNode, status, creator, created);
        TreeSet<IssueBlockedTransition> issueBlockedTransitions = this.getIssueBlockedTransitions(issueNode, status, creator, created);
        JsonNodeOptional issueTypeNode = fieldsNode.get("issuetype");
        boolean subtask = issueTypeNode.get("subtask").asBoolean();
        String type = issueTypeNode.get("name").asText();
        List<String> linkedIssuesKeys = this.getLinkedIssuesKeys(fieldsNode);
        List<String> subtasksKeys = this.getSubtasksKeys(fieldsNode);
        String parentKey = fieldsNode.get("parent").get("key").asText();
        String resolution = fieldsNode.get("resolution").get("name").asText();
        ArrayList<String> labels = new ArrayList<String>();
        fieldsNode.get("labels").elements().forEachRemaining(labelNode -> labels.add(labelNode.asText()));
        ArrayList<String> components = new ArrayList<String>();
        fieldsNode.get("components").elements().forEachRemaining(componentNode -> components.add(componentNode.get("name").asText()));
        HashMap<String, Object> customFields = new HashMap<String, Object>();
        this.customFieldsParsers.forEach((k, v) -> {
            Object val = v.apply(fieldsNode);
            if (val != null) {
                customFields.put((String)k, val);
            }
        });
        IssueData issue = IssueData.builder().created(created).creator(creator).summary(summary).description(description).issueStatusTransitions(issueStatusTransitions).issueBlockedTransitions(issueBlockedTransitions).key(key).linkedIssuesKeys(linkedIssuesKeys).parentIssueKey(parentKey).resolution(resolution).subtask(subtask).subtaskKeys(subtasksKeys).status(status).updated(updated).type(type).labels(labels).components(components).customFields(customFields).build();
        return issue;
    }

    private List<String> getSubtasksKeys(JsonNodeOptional fieldsNode) {
        ArrayList<String> subtasksKeys = new ArrayList<String>();
        fieldsNode.get("subtasks").elements().forEachRemaining(subtaskNode -> {
            String key = subtaskNode.get("key").asText();
            if (key != null) {
                subtasksKeys.add(key);
            }
        });
        return subtasksKeys;
    }

    private List<String> getLinkedIssuesKeys(JsonNodeOptional fieldsNode) {
        ArrayList<String> linkedIssuesKeys = new ArrayList<String>();
        fieldsNode.get("issuelinks").elements().forEachRemaining(issueLinkNode -> {
            if (issueLinkNode.has("outwardIssue")) {
                String key = issueLinkNode.get("outwardIssue").get("key").asText();
                if (key != null) {
                    linkedIssuesKeys.add(key);
                }
            } else {
                String key = issueLinkNode.get("inwardIssue").get("key").asText();
                if (key != null) {
                    linkedIssuesKeys.add(key);
                }
            }
        });
        return linkedIssuesKeys;
    }

    private TreeSet<IssueStatusTransition> getIssueStatusTransitions(JsonNodeOptional issueNode, String status, String creator, ZonedDateTime created) {
        String initialStatus;
        TreeSet<IssueStatusTransition> issueStatusTransitions = new TreeSet<IssueStatusTransition>();
        JsonNodeOptional changelogNode = issueNode.get("changelog");
        int totalChangelogEntries = changelogNode.get("total").asInt();
        if (totalChangelogEntries > 0) {
            changelogNode.get("histories").elements().forEachRemaining(changelogEntry -> {
                String username = changelogEntry.get("author").get("name").asText();
                ZonedDateTime createdDate = DateUtils.parseDate(changelogEntry.get("created").asText());
                changelogEntry.get("items").elements().forEachRemaining(changelogItem -> {
                    if ("status".equals(changelogItem.get("field").asText())) {
                        String fromStatus = changelogItem.get("fromString").asText();
                        String toStatus = changelogItem.get("toString").asText();
                        IssueStatusTransition issueStatusTransition = new IssueStatusTransition(username, createdDate, fromStatus, toStatus);
                        issueStatusTransitions.add(issueStatusTransition);
                    }
                });
            });
        }
        if (!issueStatusTransitions.isEmpty()) {
            IssueStatusTransition firstTransition = (IssueStatusTransition)issueStatusTransitions.first();
            initialStatus = firstTransition.getFromStatus();
        } else {
            initialStatus = status;
        }
        IssueStatusTransition issueStatusTransition = new IssueStatusTransition(creator, created, null, initialStatus);
        issueStatusTransitions.add(issueStatusTransition);
        return issueStatusTransitions;
    }

    private TreeSet<IssueBlockedTransition> getIssueBlockedTransitions(JsonNodeOptional issueNode, String status, String creator, ZonedDateTime created) {
        IssueBlockedTransition firstTransition;
        String initialStatus;
        TreeSet<IssueBlockedTransition> issueBlockedTransitions = new TreeSet<IssueBlockedTransition>();
        JsonNodeOptional changelogNode = issueNode.get("changelog");
        int totalChangelogEntries = changelogNode.get("total").asInt();
        if (totalChangelogEntries > 0) {
            changelogNode.get("histories").elements().forEachRemaining(changelogEntry -> {
                String username = changelogEntry.get("author").get("name").asText();
                ZonedDateTime createdDate = DateUtils.parseDate(changelogEntry.get("created").asText());
                changelogEntry.get("items").elements().forEachRemaining(changelogItem -> {
                    if ("Flagged".equals(changelogItem.get("field").asText())) {
                        String fromStatus = changelogItem.get("fromString").asText();
                        String toStatus = changelogItem.get("toString").asText();
                        IssueBlockedTransition issueStatusTransition = new IssueBlockedTransition(username, createdDate, fromStatus, toStatus);
                        issueBlockedTransitions.add(issueStatusTransition);
                    }
                });
            });
        }
        if (!issueBlockedTransitions.isEmpty() && (initialStatus = (firstTransition = (IssueBlockedTransition)issueBlockedTransitions.first()).getFromStatus()) != null) {
            IssueBlockedTransition trans = new IssueBlockedTransition(creator, created, null, initialStatus);
            issueBlockedTransitions.add(trans);
        }
        return issueBlockedTransitions;
    }

    @ConstructorProperties(value={"customFieldsParsers"})
    public JiraIssueParser(Map<String, Function<JsonNodeOptional, Object>> customFieldsParsers) {
        this.customFieldsParsers = customFieldsParsers;
    }
}

