/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile.jira;

import java.beans.ConstructorProperties;
import java.util.Set;

public class JiraSearchRequest {
    private final String jql;
    private int startAt = 0;
    private int maxResults = 50;
    private final Set<String> fields;
    private final Set<String> expand;

    @ConstructorProperties(value={"jql", "startAt", "maxResults", "fields", "expand"})
    JiraSearchRequest(String jql, int startAt, int maxResults, Set<String> fields, Set<String> expand) {
        this.jql = jql;
        this.startAt = startAt;
        this.maxResults = maxResults;
        this.fields = fields;
        this.expand = expand;
    }

    public static JiraSearchRequestBuilder builder() {
        return new JiraSearchRequestBuilder();
    }

    public String getJql() {
        return this.jql;
    }

    public int getStartAt() {
        return this.startAt;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public Set<String> getExpand() {
        return this.expand;
    }

    public String toString() {
        return "JiraSearchRequest(jql=" + this.getJql() + ", startAt=" + this.getStartAt() + ", maxResults=" + this.getMaxResults() + ", fields=" + this.getFields() + ", expand=" + this.getExpand() + ")";
    }

    public static class JiraSearchRequestBuilder {
        private String jql;
        private int startAt;
        private int maxResults;
        private Set<String> fields;
        private Set<String> expand;

        JiraSearchRequestBuilder() {
        }

        public JiraSearchRequestBuilder jql(String jql) {
            this.jql = jql;
            return this;
        }

        public JiraSearchRequestBuilder startAt(int startAt) {
            this.startAt = startAt;
            return this;
        }

        public JiraSearchRequestBuilder maxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public JiraSearchRequestBuilder fields(Set<String> fields) {
            this.fields = fields;
            return this;
        }

        public JiraSearchRequestBuilder expand(Set<String> expand) {
            this.expand = expand;
            return this;
        }

        public JiraSearchRequest build() {
            return new JiraSearchRequest(this.jql, this.startAt, this.maxResults, this.fields, this.expand);
        }

        public String toString() {
            return "JiraSearchRequest.JiraSearchRequestBuilder(jql=" + this.jql + ", startAt=" + this.startAt + ", maxResults=" + this.maxResults + ", fields=" + this.fields + ", expand=" + this.expand + ")";
        }
    }
}

