/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.json;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class JsonNodeOptional {
    private final Optional<JsonNode> optionalNode;

    private JsonNodeOptional(JsonNode node) {
        this.optionalNode = Optional.ofNullable(node);
    }

    private JsonNodeOptional(Optional<JsonNode> node) {
        this.optionalNode = node;
    }

    public static JsonNodeOptional of(JsonNode node) {
        return new JsonNodeOptional(node);
    }

    private static JsonNodeOptional of(Optional<JsonNode> node) {
        return new JsonNodeOptional(node);
    }

    public JsonNodeOptional get(String key) {
        Optional<JsonNode> optional = this.optionalNode.map(value -> value.get(key));
        return JsonNodeOptional.of(optional);
    }

    public String asText() {
        return this.optionalNode.filter(node -> !node.isNull()).map(JsonNode::asText).orElse(null);
    }

    public boolean asBoolean() {
        return this.optionalNode.filter(node -> !node.isNull()).map(JsonNode::asBoolean).orElse(false);
    }

    public Iterator<JsonNodeOptional> elements() {
        return ((List)this.optionalNode.map(JsonNode::elements).map(iterator -> {
            Iterable iterable = () -> iterator;
            return StreamSupport.stream(iterable.spliterator(), false).map(jsonNode -> JsonNodeOptional.of(jsonNode)).collect(Collectors.toList());
        }).orElse(new ArrayList())).iterator();
    }

    public int asInt() {
        return this.optionalNode.filter(node -> !node.isNull()).map(JsonNode::asInt).orElse(0);
    }

    public boolean has(String fieldName) {
        return this.get(fieldName).isPresent();
    }

    private boolean isPresent() {
        return this.optionalNode.isPresent();
    }
}

