/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.workload;

import java.util.HashMap;
import java.util.Map;
import pl.kaszaq.howfastyouaregoing.agile.Issue;

public class WorkloadDailyReport {
    private final Map<Issue, Double> reportedWorkLoadOnIssue = new HashMap<Issue, Double>();
    private double totalWorkloadOnIssues;

    public void reportWorkloadOnIssue(Issue issue, Double value) {
        this.reportedWorkLoadOnIssue.merge(issue, value, Double::sum);
        this.totalWorkloadOnIssues += value.doubleValue();
    }

    public Map<Issue, Double> calculateDistribution() {
        Double totalVal = this.getTotalWorkloadOnIssues();
        HashMap<Issue, Double> workloadDistribution = new HashMap<Issue, Double>();
        this.getReportedWorkLoadOnIssue().forEach((k, v) -> {
            double val = 100.0 * v / totalVal;
            workloadDistribution.put((Issue)k, val);
        });
        return workloadDistribution;
    }

    public Map<Issue, Double> getReportedWorkLoadOnIssue() {
        return this.reportedWorkLoadOnIssue;
    }

    public double getTotalWorkloadOnIssues() {
        return this.totalWorkloadOnIssues;
    }
}

