/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZonedDateTime;

public class IssueBlockedTransition
implements Comparable<IssueBlockedTransition> {
    private final String user;
    private final ZonedDateTime date;
    private final String fromStatus;
    private final String toStatus;

    public IssueBlockedTransition(String user, ZonedDateTime date, String fromStatus, String toStatus) {
        this.user = user;
        this.date = date;
        this.fromStatus = fromStatus;
        this.toStatus = toStatus;
    }

    public String getUser() {
        return this.user;
    }

    public ZonedDateTime getDate() {
        return this.date;
    }

    @JsonIgnore
    public boolean isBlocked() {
        return this.toStatus != null && !this.toStatus.isEmpty();
    }

    @Override
    public int compareTo(IssueBlockedTransition o) {
        return this.getDate().compareTo(o.getDate());
    }

    public String getFromStatus() {
        return this.fromStatus;
    }

    public String getToStatus() {
        return this.toStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueBlockedTransition)) {
            return false;
        }
        IssueBlockedTransition other = (IssueBlockedTransition)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        ZonedDateTime this$date = this.getDate();
        ZonedDateTime other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        String this$fromStatus = this.getFromStatus();
        String other$fromStatus = other.getFromStatus();
        if (this$fromStatus == null ? other$fromStatus != null : !this$fromStatus.equals(other$fromStatus)) {
            return false;
        }
        String this$toStatus = this.getToStatus();
        String other$toStatus = other.getToStatus();
        return !(this$toStatus == null ? other$toStatus != null : !this$toStatus.equals(other$toStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueBlockedTransition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        ZonedDateTime $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        String $fromStatus = this.getFromStatus();
        result = result * 59 + ($fromStatus == null ? 43 : $fromStatus.hashCode());
        String $toStatus = this.getToStatus();
        result = result * 59 + ($toStatus == null ? 43 : $toStatus.hashCode());
        return result;
    }
}

