/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import pl.kaszaq.howfastyouaregoing.agile.IssueBlockedTransition;
import pl.kaszaq.howfastyouaregoing.agile.IssueData;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;
import pl.kaszaq.howfastyouaregoing.utils.DateUtils;

class IssueDataWrapper {
    private final IssueData issue;
    private final AtomicReference<Object> timeInStatus = new AtomicReference();
    private final AtomicReference<Object> allDayBlockedDays = new AtomicReference();
    private final Map<String, SortedSet<LocalDate>> datesInStatus = new HashMap<String, SortedSet<LocalDate>>();

    public Duration getDurationInStatuses(String ... statuses) {
        return Stream.of(statuses).map(status -> this.getTimeInStatus().getOrDefault(status, Duration.ZERO)).reduce(Duration::plus).get();
    }

    public boolean isStatusOnDay(LocalDate date, Set<String> statuses) {
        return statuses.stream().anyMatch(status -> this.getDatesInStatus((String)status).contains(date));
    }

    private SortedSet<LocalDate> getDatesInStatus(String status) {
        return this.datesInStatus.computeIfAbsent(status, s -> this.calculateDatesInStatus((String)s));
    }

    private SortedSet<LocalDate> calculateDatesInStatus(String requiredStatus) {
        TreeSet<LocalDate> datesInCurrentStatus = new TreeSet<LocalDate>();
        ZonedDateTime temp = null;
        for (IssueStatusTransition issueStatusTransition : this.issue.getIssueStatusTransitions()) {
            if (temp != null) {
                datesInCurrentStatus.addAll(DateUtils.getCollectionOfLocalDates(temp, issueStatusTransition.getDate()));
                temp = null;
            }
            if (!requiredStatus.equals(issueStatusTransition.getToStatus())) continue;
            temp = issueStatusTransition.getDate();
        }
        if (temp != null) {
            datesInCurrentStatus.addAll(DateUtils.getCollectionOfLocalDates(temp, ZonedDateTime.now()));
        }
        return datesInCurrentStatus;
    }

    private Set<LocalDate> calculateDatesWhenAllDayBlocked() {
        HashSet<LocalDate> blockedDays = new HashSet<LocalDate>();
        ZonedDateTime temp = null;
        for (IssueBlockedTransition issueBlockedTransition : this.issue.getIssueBlockedTransitions()) {
            if (!issueBlockedTransition.isBlocked()) {
                if (temp == null) {
                    System.out.println("zonk");
                }
                blockedDays.addAll(DateUtils.getCollectionOfLocalDatesBetweenDateExclusive(temp, issueBlockedTransition.getDate()));
                temp = null;
                continue;
            }
            if (temp != null) continue;
            temp = issueBlockedTransition.getDate();
        }
        if (temp != null) {
            blockedDays.addAll(DateUtils.getCollectionOfLocalDatesBetweenDateExclusive(temp, ZonedDateTime.now()));
            blockedDays.add(LocalDate.now());
        }
        return blockedDays;
    }

    private Duration calculateTotalTimeInStatus(IssueData issue, String status) {
        return this.calculateTimeInStatus(issue, status, (from, to) -> Duration.between(from, to));
    }

    private Duration calculateTimeInStatus(IssueData issue, String status, BiFunction<ZonedDateTime, ZonedDateTime, Duration> durationFunction) {
        ZonedDateTime temp = null;
        Duration duration = Duration.ZERO;
        for (IssueStatusTransition issueStatusTransition : issue.getIssueStatusTransitions()) {
            if (temp != null) {
                duration = duration.plus(durationFunction.apply(temp, issueStatusTransition.getDate()));
                temp = null;
            }
            if (!status.equals(issueStatusTransition.getToStatus())) continue;
            temp = issueStatusTransition.getDate();
        }
        if (temp != null) {
            duration = duration.plus(durationFunction.apply(temp, ZonedDateTime.now()));
        }
        return duration;
    }

    private Map<String, Duration> calculateTimeInStatus() {
        return this.issue.getIssueStatusTransitions().stream().map(t -> t.getToStatus()).distinct().collect(() -> new HashMap(), (map, status) -> map.put(status, this.calculateTotalTimeInStatus(this.issue, (String)status)), Map::putAll);
    }

    @ConstructorProperties(value={"issue"})
    public IssueDataWrapper(IssueData issue) {
        this.issue = issue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Duration> getTimeInStatus() {
        Object value = this.timeInStatus.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.timeInStatus;
            synchronized (atomicReference) {
                value = this.timeInStatus.get();
                if (value == null) {
                    Map<String, Duration> actualValue = this.calculateTimeInStatus();
                    value = actualValue == null ? this.timeInStatus : actualValue;
                    this.timeInStatus.set(value);
                }
            }
        }
        return (Map)(value == this.timeInStatus ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LocalDate> getAllDayBlockedDays() {
        Object value = this.allDayBlockedDays.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.allDayBlockedDays;
            synchronized (atomicReference) {
                value = this.allDayBlockedDays.get();
                if (value == null) {
                    Set<LocalDate> actualValue = this.calculateDatesWhenAllDayBlocked();
                    value = actualValue == null ? this.allDayBlockedDays : actualValue;
                    this.allDayBlockedDays.set(value);
                }
            }
        }
        return (Set)(value == this.allDayBlockedDays ? null : value);
    }
}

