/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;
import pl.kaszaq.howfastyouaregoing.utils.CommonPredicates;

public class IssuePredicates {
    public static Predicate<Issue> updatedAfter(ZonedDateTime date) {
        return issue -> issue.getUpdated().isAfter(date);
    }

    public static Predicate<Issue> createdAfter(ZonedDateTime date) {
        return issue -> issue.getCreated().isAfter(date);
    }

    public static Predicate<Issue> hasStatusTransitionsThat(Predicate<IssueStatusTransition> ... predicates) {
        Optional<Predicate<IssueStatusTransition>> predicate = Arrays.stream(predicates).reduce((p1, p2) -> p1.and(p2));
        return issue -> issue.getIssueStatusTransitions().stream().anyMatch(predicate.orElse(CommonPredicates.alwaysTrue()));
    }

    public static Predicate<Issue> hasSubtasks() {
        return issue -> !issue.getSubtaskKeys().isEmpty();
    }

    public static Predicate<Issue> isSubtask() {
        return issue -> issue.isSubtask();
    }

    public static Predicate<Issue> isEpic() {
        return issue -> issue.getType().equals("Epic");
    }

    public static Predicate<Issue> isType(String ... acceptableTypes) {
        return IssuePredicates.isType((Set<String>)ImmutableSet.copyOf((Object[])acceptableTypes));
    }

    public static Predicate<Issue> isType(Set<String> acceptableTypes) {
        return issue -> acceptableTypes.contains(issue.getType());
    }

    public static Predicate<Issue> reportedBy(String ... reporters) {
        return IssuePredicates.reportedBy((Set<String>)ImmutableSet.copyOf((Object[])reporters));
    }

    public static Predicate<Issue> reportedBy(Set<String> allowedReporters) {
        return issue -> issue.getCreator() != null && allowedReporters.contains(issue.getCreator());
    }

    public static Predicate<Issue> inResolution(String ... resolutions) {
        return IssuePredicates.inResolution((Set<String>)ImmutableSet.copyOf((Object[])resolutions));
    }

    public static Predicate<Issue> inResolution(Set<String> allowedResolutions) {
        return issue -> issue.getResolution() != null && allowedResolutions.contains(issue.getResolution());
    }

    public static Predicate<Issue> inStatus(String ... statusNames) {
        return IssuePredicates.inStatus((Set<String>)ImmutableSet.copyOf((Object[])statusNames));
    }

    public static Predicate<Issue> inStatus(Set<String> allowedStatuses) {
        return issue -> allowedStatuses.contains(issue.getStatus());
    }

    public static Predicate<Issue> hasAllComponents(String ... components) {
        return IssuePredicates.hasAllComponents((Set<String>)ImmutableSet.copyOf((Object[])components));
    }

    public static Predicate<Issue> hasAllComponents(Set<String> requiredComponents) {
        return issue -> issue.getComponents().containsAll(requiredComponents);
    }

    public static Predicate<Issue> hasAllLabels(String ... labels) {
        return IssuePredicates.hasAllLabels((Set<String>)ImmutableSet.copyOf((Object[])labels));
    }

    public static Predicate<Issue> hasAllLabels(Set<String> requiredLabels) {
        return issue -> issue.getLabels().containsAll(requiredLabels);
    }

    public static Predicate<Issue> hasAnyComponents(String ... components) {
        return IssuePredicates.hasAnyComponents((Set<String>)ImmutableSet.copyOf((Object[])components));
    }

    public static Predicate<Issue> hasAnyComponents(Set<String> requiredComponents) {
        return issue -> !Collections.disjoint(issue.getComponents(), requiredComponents);
    }

    public static Predicate<Issue> hasAnyLabels(String ... labels) {
        return IssuePredicates.hasAnyLabels((Set<String>)ImmutableSet.copyOf((Object[])labels));
    }

    public static Predicate<Issue> hasAnyLabels(Set<String> requiredLabels) {
        return issue -> !Collections.disjoint(issue.getLabels(), requiredLabels);
    }

    public static Predicate<Issue> inStatusOnDay(LocalDate date, String ... statusNames) {
        ImmutableSet allowedStatuses = ImmutableSet.copyOf((Object[])statusNames);
        return arg_0 -> IssuePredicates.lambda$inStatusOnDay$15(date, (Set)allowedStatuses, arg_0);
    }

    public static Predicate<Issue> isBlockedEntireDay(LocalDate date) {
        return issue -> issue.getAllDayBlockedDays().contains(date);
    }

    private static /* synthetic */ boolean lambda$inStatusOnDay$15(LocalDate date, Set allowedStatuses, Issue issue) {
        return issue.isStatusOnDay(date, allowedStatuses);
    }
}

