/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IssueStatusMapping {
    private final Map<String, String> statusMap;

    public IssueStatusMapping(Map<String, String> statusMap) {
        this.statusMap = this.shortenLinks(this.removeLoopsFromGraph(statusMap));
    }

    private Map<String, String> shortenLinks(Map<String, String> map) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map.forEach((k, v) -> map2.put((String)k, IssueStatusMapping.getParent(map, v)));
        return map2;
    }

    private Map<String, String> removeLoopsFromGraph(Map<String, String> statusMap1) {
        HashMap<String, String> map = new HashMap<String, String>();
        statusMap1.forEach((k, v) -> IssueStatusMapping.putToMapIfWontCreateChain(map, k, v));
        return map;
    }

    private static void putToMapIfWontCreateChain(Map<String, String> map, String k, String v) {
        if (IssueStatusMapping.getInvalidChainConnection(map, k, v) == null) {
            map.put(k, v);
        }
    }

    private static String getParent(Map<String, String> map, String child) {
        String parent = map.get(child);
        if (parent == null) {
            return child;
        }
        return IssueStatusMapping.getParent(map, parent);
    }

    private static String getInvalidChainConnection(Map<String, String> statusMap, String childStatus, String parentStatus) {
        String val = statusMap.get(parentStatus);
        if (val == null) {
            return null;
        }
        if (val.equals(childStatus)) {
            return parentStatus;
        }
        return IssueStatusMapping.getInvalidChainConnection(statusMap, childStatus, val);
    }

    public String mapStatus(String oldStatus) {
        return oldStatus == null ? null : this.statusMap.getOrDefault(oldStatus, oldStatus);
    }

    public Map<String, String> getMappings() {
        return Collections.unmodifiableMap(this.statusMap);
    }
}

