/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.IssuePredicates;

public class StatusOrderCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(StatusOrderCalculator.class);

    static List<String> getStatusOrder(Collection<Issue> issues) {
        Map<Optional<String>, Map<String, Long>> recentTransitions = StatusOrderCalculator.countRecentTransitions(issues);
        Map<Optional<String>, Map<String, Long>> transitions = StatusOrderCalculator.countAllTransitions(issues);
        LOG.debug("Transitions {}", transitions);
        Map<String, String> mapping = StatusOrderCalculator.calculateMapping(recentTransitions, transitions);
        LOG.debug("Mapping {}", mapping);
        String tempStatus = null;
        LinkedList<String> statusOrder = new LinkedList<String>();
        do {
            if ((tempStatus = mapping.get(tempStatus)) != null && !statusOrder.contains(tempStatus)) {
                statusOrder.add(tempStatus);
                continue;
            }
            tempStatus = null;
        } while (tempStatus != null);
        List<String> toStatuses = StatusOrderCalculator.calculateAllToStatuses(transitions);
        for (String status : toStatuses) {
            if (statusOrder.contains(status)) continue;
            String highestFrom = null;
            long val = 0L;
            for (Map.Entry<Optional<String>, Map<String, Long>> entry : transitions.entrySet()) {
                Long tempVal = entry.getValue().get(status);
                if (tempVal == null || tempVal <= val) continue;
                val = tempVal;
                highestFrom = entry.getKey().orElse(null);
            }
            int order = statusOrder.indexOf(highestFrom) + 1;
            statusOrder.add(order, status);
        }
        return statusOrder;
    }

    private static List<String> calculateAllToStatuses(Map<Optional<String>, Map<String, Long>> transitions) {
        return transitions.values().stream().flatMap(map -> map.keySet().stream()).distinct().collect(Collectors.toList());
    }

    private static Map<String, String> calculateMapping(Map<Optional<String>, Map<String, Long>> recentTransitions, Map<Optional<String>, Map<String, Long>> transitions) {
        Map<String, String> mapping = recentTransitions.isEmpty() ? StatusOrderCalculator.calculateMapping(transitions) : StatusOrderCalculator.calculateMapping(recentTransitions);
        return mapping;
    }

    private static Map<Optional<String>, Map<String, Long>> countAllTransitions(Collection<Issue> issues) {
        return issues.stream().flatMap(i -> i.getIssueStatusTransitions().stream()).collect(Collectors.groupingBy(i -> Optional.ofNullable(i.getFromStatus()), Collectors.groupingBy(i -> i.getToStatus(), Collectors.counting())));
    }

    private static Map<Optional<String>, Map<String, Long>> countRecentTransitions(Collection<Issue> issues) {
        return issues.stream().filter(IssuePredicates.updatedAfter(LocalDate.now().minusMonths(6L).atStartOfDay(ZoneId.systemDefault()))).flatMap(i -> i.getIssueStatusTransitions().stream()).collect(Collectors.groupingBy(i -> Optional.ofNullable(i.getFromStatus()), Collectors.groupingBy(i -> i.getToStatus(), Collectors.counting())));
    }

    private static Map<String, String> calculateMapping(Map<Optional<String>, Map<String, Long>> transitions) {
        HashMap<String, String> mapping = new HashMap<String, String>();
        transitions.forEach((k, v) -> {
            String highestTo = null;
            Long val = 0L;
            for (Map.Entry entry : v.entrySet()) {
                if (val >= (Long)entry.getValue()) continue;
                val = (Long)entry.getValue();
                highestTo = (String)entry.getKey();
            }
            mapping.put(k.orElse(null), highestTo);
        });
        return mapping;
    }
}

