/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile.grouping;

import java.util.HashSet;
import java.util.Set;
import pl.kaszaq.howfastyouaregoing.agile.Issue;

public class IssueHierarchyNode {
    private final Set<IssueHierarchyNode> childNodes = new HashSet<IssueHierarchyNode>();
    private final Issue issue;

    IssueHierarchyNode(Issue issue) {
        this.issue = issue;
    }

    void link(IssueHierarchyNode hierarchyNode) {
        this.childNodes.add(hierarchyNode);
    }

    public void print() {
        this.print(0);
    }

    private void print(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("\t");
        }
        System.out.println(this.issue.getKey());
        ++indent;
        for (IssueHierarchyNode childNode : this.childNodes) {
            childNode.print(indent);
        }
    }

    boolean hasChild(Issue issue) {
        if (this.childNodes.stream().filter(cn -> cn.getIssue().equals(issue)).findFirst().isPresent()) {
            return true;
        }
        return this.childNodes.stream().filter(cn -> cn.hasChild(issue)).findFirst().isPresent();
    }

    public Set<Issue> getLeafsIssues() {
        HashSet<Issue> leafIssues = new HashSet<Issue>();
        if (this.childNodes.isEmpty()) {
            leafIssues.add(this.issue);
        } else {
            this.childNodes.forEach(cn -> leafIssues.addAll(cn.getLeafsIssues()));
        }
        return leafIssues;
    }

    public Set<IssueHierarchyNode> getChildNodes() {
        return this.childNodes;
    }

    public Issue getIssue() {
        return this.issue;
    }
}

