/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile.jira;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.Config;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectDataObserver;
import pl.kaszaq.howfastyouaregoing.agile.IssueData;
import pl.kaszaq.howfastyouaregoing.agile.jira.AgileProjectDataReader;
import pl.kaszaq.howfastyouaregoing.agile.jira.JiraIssueParser;
import pl.kaszaq.howfastyouaregoing.agile.jira.JiraProjectStatusReader;
import pl.kaszaq.howfastyouaregoing.agile.jira.JiraSearchRequest;
import pl.kaszaq.howfastyouaregoing.agile.pojo.AgileProjectData;
import pl.kaszaq.howfastyouaregoing.agile.pojo.AgileProjectStatuses;
import pl.kaszaq.howfastyouaregoing.http.HttpClient;
import pl.kaszaq.howfastyouaregoing.json.JsonNodeOptional;
import pl.kaszaq.howfastyouaregoing.storage.FileStorage;

public class JiraAgileProjectDataReader
implements AgileProjectDataReader {
    private static final Logger LOG = LoggerFactory.getLogger(JiraAgileProjectDataReader.class);
    private final JiraIssueParser issueParser;
    private final HttpClient httpClient;
    private final File jiraCacheIssuesDirectory;
    private final String jiraSearchEndpoint;
    private final Set<String> customFieldsNames;
    private final int minutesUntilUpdate;
    private final FileStorage fileStorage;
    private final JiraProjectStatusReader statusReader;
    private final boolean emptyDescriptionAndSummary;
    private final boolean cacheRawJiraFiles;

    JiraAgileProjectDataReader(HttpClient client, File jiraCacheIssuesDirectory, String jiraUrl, Map<String, Function<JsonNodeOptional, Object>> customFieldsParsers, int minutesUntilUpdate, FileStorage fileStorage, boolean emptyDescriptionAndSummary, boolean cacheRawJiraFiles) {
        this.jiraCacheIssuesDirectory = jiraCacheIssuesDirectory;
        this.jiraSearchEndpoint = jiraUrl + "/rest/api/2/search";
        this.httpClient = client;
        this.issueParser = new JiraIssueParser(customFieldsParsers);
        this.customFieldsNames = new HashSet<String>(customFieldsParsers.keySet());
        this.minutesUntilUpdate = minutesUntilUpdate;
        this.fileStorage = fileStorage;
        this.statusReader = new JiraProjectStatusReader(this.httpClient, jiraUrl, jiraCacheIssuesDirectory, fileStorage, cacheRawJiraFiles);
        this.emptyDescriptionAndSummary = emptyDescriptionAndSummary;
        this.cacheRawJiraFiles = cacheRawJiraFiles;
    }

    @Override
    public AgileProjectData updateProject(AgileProjectData projectData, AgileProjectDataObserver observer, boolean cacheOnly) throws IOException {
        if (this.requiresUpdate(projectData)) {
            if (this.cacheRawJiraFiles) {
                projectData = this.tryUpdateFromLocalJiraFiles(projectData, observer);
            }
            if (!cacheOnly) {
                projectData = this.updateCachedProject(projectData, observer);
            }
        }
        observer.updated(projectData, 1.0);
        return projectData;
    }

    private boolean requiresUpdate(AgileProjectData project) {
        return project.getLastUpdated().isBefore(ZonedDateTime.now().minusMinutes(this.minutesUntilUpdate));
    }

    private File getIssueFile(String issueId) {
        return new File(this.jiraCacheIssuesDirectory, issueId + ".json");
    }

    private File[] getIssuesFiles(String projectId) {
        return this.jiraCacheIssuesDirectory.listFiles((dir1, name) -> name.matches(projectId + "-\\d+\\.json"));
    }

    private AgileProjectData updateCachedProject(AgileProjectData projectData, AgileProjectDataObserver observer) throws IOException {
        ZonedDateTime lastUpdatedIssue;
        ZoneId userJiraZoneId = ZoneId.systemDefault();
        String lastUpdatedQueryValue = projectData.getLastUpdatedIssue().withZoneSameInstant(userJiraZoneId).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm"));
        AgileProjectStatuses newStatuses = this.statusReader.getProjectStatuses(projectData.getProjectId(), false);
        int maxResults = 50;
        int startAt = 0;
        int total = 0;
        do {
            JiraSearchRequest searchRequest = JiraSearchRequest.builder().expand((Set<String>)ImmutableSet.of((Object)"changelog")).jql("project = " + projectData.getProjectId() + " AND updated >= \"" + lastUpdatedQueryValue + "\" ORDER BY updated ASC").maxResults(maxResults).startAt(startAt).build();
            String response = this.httpClient.postJson(this.jiraSearchEndpoint, searchRequest);
            JsonNode tree = Config.OBJECT_MAPPER.readTree(response);
            maxResults = tree.get("maxResults").asInt();
            startAt = tree.get("startAt").asInt();
            total = tree.get("total").asInt();
            lastUpdatedIssue = projectData.getLastUpdatedIssue();
            HashMap<String, IssueData> issues = new HashMap<String, IssueData>(projectData.getIssues());
            Iterator issuesIterator = tree.get("issues").elements();
            while (issuesIterator.hasNext()) {
                JsonNode node = (JsonNode)issuesIterator.next();
                IssueData issueData = this.issueParser.parseJiraIssue(node, this.emptyDescriptionAndSummary);
                if (issueData.getUpdated().isAfter(lastUpdatedIssue)) {
                    lastUpdatedIssue = issueData.getUpdated();
                }
                issues.put(issueData.getKey(), issueData);
                if (!this.cacheRawJiraFiles) continue;
                try {
                    this.fileStorage.storeFile(this.getIssueFile(issueData.getKey()), Config.OBJECT_MAPPER.writeValueAsString((Object)node));
                }
                catch (IOException ex) {
                    LOG.warn("Unable to store vanila jira issue data. Issue id: {}", (Object)issueData.getKey(), (Object)ex);
                }
            }
            projectData = new AgileProjectData(projectData.getProjectId(), lastUpdatedIssue, lastUpdatedIssue, issues, this.customFieldsNames, newStatuses);
            if (total <= 0 || (startAt += maxResults) >= total) continue;
            observer.updated(projectData, (double)startAt / (double)total);
        } while (startAt < total);
        projectData = new AgileProjectData(projectData.getProjectId(), lastUpdatedIssue, ZonedDateTime.now(), new HashMap<String, IssueData>(projectData.getIssues()), this.customFieldsNames, newStatuses);
        return projectData;
    }

    private AgileProjectData tryUpdateFromLocalJiraFiles(AgileProjectData projectData, AgileProjectDataObserver observer) throws IOException {
        File[] files;
        if (projectData.getIssues().isEmpty() && (files = this.getIssuesFiles(projectData.getProjectId())).length > 0) {
            AgileProjectStatuses statuses = null;
            if (this.statusReader.areStatusesCached(projectData.getProjectId())) {
                statuses = this.statusReader.getProjectStatuses(projectData.getProjectId(), true);
            }
            LOG.info("Project was empty but there were files from jira found in cache. Will try to create project from them before attempting to connect to jira. If this behavior was not expected and you need to read all files freshly from jira, you have to remove all cached files, not only project file.");
            ZonedDateTime lastUpdatedIssue = projectData.getLastUpdatedIssue();
            HashMap<String, IssueData> issues = new HashMap<String, IssueData>(projectData.getIssues());
            for (File file : files) {
                IssueData issueData = this.issueParser.parseJiraIssue(Config.OBJECT_MAPPER.readTree(this.fileStorage.loadFile(file)), this.emptyDescriptionAndSummary);
                if (issueData.getUpdated().isAfter(lastUpdatedIssue)) {
                    lastUpdatedIssue = issueData.getUpdated();
                }
                issues.put(issueData.getKey(), issueData);
            }
            projectData = new AgileProjectData(projectData.getProjectId(), lastUpdatedIssue, lastUpdatedIssue, issues, this.customFieldsNames, statuses);
            observer.updated(projectData, 0.0);
        }
        return projectData;
    }
}

