/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile.jira;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import pl.kaszaq.howfastyouaregoing.Config;
import pl.kaszaq.howfastyouaregoing.agile.pojo.AgileProjectStatuses;
import pl.kaszaq.howfastyouaregoing.http.HttpClient;
import pl.kaszaq.howfastyouaregoing.json.JsonNodeOptional;
import pl.kaszaq.howfastyouaregoing.storage.FileStorage;

public class JiraProjectStatusReader {
    private final HttpClient httpClient;
    private final String jiraUrl;
    private final File jiraCacheIssuesDirectory;
    private final boolean cacheRawJiraFiles;
    private final FileStorage fileStorage;

    public JiraProjectStatusReader(HttpClient httpClient, String jiraUrl, File jiraCacheIssuesDirectory, FileStorage fileStorage, boolean cacheRawJiraFiles) {
        this.httpClient = httpClient;
        this.jiraUrl = jiraUrl;
        this.jiraCacheIssuesDirectory = jiraCacheIssuesDirectory;
        this.fileStorage = fileStorage;
        this.cacheRawJiraFiles = cacheRawJiraFiles;
    }

    boolean areStatusesCached(String projectKey) {
        return this.cacheRawJiraFiles && new File(this.jiraCacheIssuesDirectory, projectKey + "-STATUSES.json").exists();
    }

    AgileProjectStatuses getProjectStatuses(String projectKey, boolean readFromCache) throws IOException {
        String response;
        String url = this.jiraUrl + "/rest/api/2/project/" + projectKey + "/statuses";
        File file = new File(this.jiraCacheIssuesDirectory, projectKey + "-STATUSES.json");
        if (readFromCache) {
            response = this.fileStorage.loadFile(file);
        } else {
            response = this.httpClient.get(url);
            if (this.cacheRawJiraFiles) {
                this.fileStorage.storeFile(file, response);
            }
        }
        HashSet<String> indeterminateStatuses = new HashSet<String>();
        HashSet<String> newStatuses = new HashSet<String>();
        HashSet<String> doneStatuses = new HashSet<String>();
        HashSet<String> undefinedStatuses = new HashSet<String>();
        JsonNodeOptional tree = JsonNodeOptional.of(Config.OBJECT_MAPPER.readTree(response));
        Iterator<JsonNodeOptional> it = tree.elements();
        while (it.hasNext()) {
            JsonNodeOptional val = it.next();
            Iterator<JsonNodeOptional> it2 = val.get("statuses").elements();
            while (it2.hasNext()) {
                JsonNodeOptional val2 = it2.next();
                String name = val2.get("name").asText();
                String category = val2.get("statusCategory").get("key").asText();
                if ("new".equals(category)) {
                    newStatuses.add(name);
                }
                if ("done".equals(category)) {
                    doneStatuses.add(name);
                }
                if ("indeterminate".equals(category)) {
                    indeterminateStatuses.add(name);
                }
                if (!"undefined".equals(category)) continue;
                undefinedStatuses.add(name);
            }
        }
        return new AgileProjectStatuses(indeterminateStatuses, newStatuses, doneStatuses, undefinedStatuses);
    }
}

