/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.cfd;

import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;

public class CfdData {
    SortedMap<LocalDate, DailyStatusChanges> cfdItems = new TreeMap<LocalDate, DailyStatusChanges>();

    void addTransition(IssueStatusTransition transition) {
        String fromStatus = transition.getFromStatus();
        String toStatus = transition.getToStatus();
        if (toStatus.equals(fromStatus)) {
            return;
        }
        LocalDate eventDate = LocalDate.from(transition.getDate());
        DailyStatusChanges item = this.cfdItems.computeIfAbsent(eventDate, date -> new DailyStatusChanges());
        item.transitionedToStatus(toStatus);
        item.transitionedFromStatus(fromStatus);
    }

    public SortedMap<LocalDate, DailyStatusChanges> getDailyTransitions() {
        return Collections.unmodifiableSortedMap(this.cfdItems);
    }

    public static class DailyStatusChanges {
        private final Map<String, Integer> statusChanges = new HashMap<String, Integer>();

        public Map<String, Integer> getStatusChanges() {
            return this.statusChanges;
        }

        private void transitionedToStatus(String toStatus) {
            this.statusChanges.merge(toStatus, 1, Integer::sum);
        }

        private void transitionedFromStatus(String fromStatus) {
            this.statusChanges.merge(fromStatus, -1, Integer::sum);
        }

        public int getValueChangeForStatus(String status) {
            return this.statusChanges.getOrDefault(status, 0);
        }
    }
}

