/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.cycletime;

import java.time.LocalDate;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import pl.kaszaq.howfastyouaregoing.agile.AgileProject;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.IssuePredicates;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;

public final class CycleTimeComputer {
    public static SortedMap<LocalDate, Double> calulcateCycleTime(AgileProject agileProject, Predicate<Issue> filters, Set<String> finalStatuses, String ... statusNames) {
        TreeMap<LocalDate, Double> cycleTimeStatistics = new TreeMap<LocalDate, Double>(agileProject.getAllIssues().stream().filter(filters).filter(IssuePredicates.inStatus(finalStatuses)).filter(i -> i.getIssueStatusTransitions().stream().anyMatch(st -> finalStatuses.contains(st.getToStatus()))).collect(Collectors.groupingBy(i -> CycleTimeComputer.getClosedDate(i, finalStatuses), Collectors.averagingDouble(i -> (double)i.getDurationInStatuses(statusNames).getSeconds() / 3600.0))));
        return cycleTimeStatistics;
    }

    private static LocalDate getClosedDate(Issue i, Set<String> finalStatuses) {
        LocalDate returnDate = null;
        boolean previousWasClosed = false;
        for (IssueStatusTransition issueStatusTransition : i.getIssueStatusTransitions()) {
            if (!previousWasClosed && finalStatuses.contains(issueStatusTransition.getToStatus())) {
                returnDate = issueStatusTransition.getDate().toLocalDate();
                previousWasClosed = true;
                continue;
            }
            if (finalStatuses.contains(issueStatusTransition.getToStatus())) continue;
            previousWasClosed = false;
        }
        return returnDate;
    }

    private CycleTimeComputer() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

