/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.agile.AgileProject;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectConfiguration;
import pl.kaszaq.howfastyouaregoing.agile.AgileProjectProvider;
import pl.kaszaq.howfastyouaregoing.agile.Issue;

public class AgileClient {
    private static final Logger LOG = LoggerFactory.getLogger(AgileClient.class);
    private static final Pattern ISSUE_PATTERN = Pattern.compile("(\\w+)-\\d+.*");
    private final Map<String, AgileProject> agileProjects = new HashMap<String, AgileProject>();
    private final AgileProjectProvider agileProjectProvider;
    private final Map<String, AgileProjectConfiguration> projectsConfiguration;
    private final AgileProjectConfiguration DEFAULT_PROJECT_CONFIGURATION = AgileProjectConfiguration.builder().build();

    AgileClient(Map<String, AgileProjectConfiguration> configuration, AgileProjectProvider agileProjectProvider) {
        this.projectsConfiguration = configuration;
        this.agileProjectProvider = agileProjectProvider;
    }

    public AgileProject getAgileProject(String projectId) {
        return this.getProject(projectId).orElseThrow(() -> new RuntimeException("Project " + projectId + " not found"));
    }

    public Optional<Issue> getIssue(String issueId) {
        Matcher m = ISSUE_PATTERN.matcher(issueId);
        if (!m.matches()) {
            return Optional.empty();
        }
        String projectId = m.group(1);
        Optional<AgileProject> agileProject = this.getProject(projectId);
        return agileProject.map(project -> project.getIssue(issueId));
    }

    private Optional<AgileProject> getProject(String projectId) {
        return Optional.ofNullable(this.agileProjects.computeIfAbsent(projectId, id -> this.agileProjectProvider.loadProject((String)id, this.getConfiguration((String)id)).orElse(null)));
    }

    private AgileProjectConfiguration getConfiguration(String id) {
        return this.projectsConfiguration.getOrDefault(id, this.DEFAULT_PROJECT_CONFIGURATION);
    }
}

