/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile;

import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.StatusOrderCalculator;

public class AgileProject {
    private final Map<String, Issue> data;
    private final String id;
    private final AtomicReference<Object> firstIssueCreateDate = new AtomicReference();
    private final AtomicReference<Object> probableStatusOrder = new AtomicReference();
    private final AtomicReference<Object> allIssues = new AtomicReference();

    AgileProject(String id, Map<String, Issue> data) {
        this.id = id;
        this.data = new HashMap<String, Issue>(data);
    }

    public Issue getIssue(String issueId) {
        return this.data.get(issueId);
    }

    public boolean contains(Issue issue) {
        return this.data.containsKey(issue.getKey());
    }

    public boolean contains(String issueKey) {
        return this.data.containsKey(issueKey);
    }

    private Collection<Issue> calculateAllIssues() {
        return Collections.unmodifiableCollection(this.data.values());
    }

    private List<String> calculateProbableStatusOrder() {
        return Collections.unmodifiableList(new ArrayList<String>(StatusOrderCalculator.getStatusOrder(this.getAllIssues())));
    }

    private LocalDateTime calculateFirstIssueCreateDate() {
        return this.getAllIssues().stream().map(i -> i.getCreated().toLocalDateTime()).min((o1, o2) -> o1.compareTo((ChronoLocalDateTime<?>)o2)).orElse(null);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgileProject other = (AgileProject)obj;
        return Objects.equals(this.id, other.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDateTime getFirstIssueCreateDate() {
        Object value = this.firstIssueCreateDate.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.firstIssueCreateDate;
            synchronized (atomicReference) {
                value = this.firstIssueCreateDate.get();
                if (value == null) {
                    LocalDateTime actualValue = this.calculateFirstIssueCreateDate();
                    value = actualValue == null ? this.firstIssueCreateDate : actualValue;
                    this.firstIssueCreateDate.set(value);
                }
            }
        }
        return (LocalDateTime)(value == this.firstIssueCreateDate ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getProbableStatusOrder() {
        Object value = this.probableStatusOrder.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.probableStatusOrder;
            synchronized (atomicReference) {
                value = this.probableStatusOrder.get();
                if (value == null) {
                    List<String> actualValue = this.calculateProbableStatusOrder();
                    value = actualValue == null ? this.probableStatusOrder : actualValue;
                    this.probableStatusOrder.set(value);
                }
            }
        }
        return (List)(value == this.probableStatusOrder ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Issue> getAllIssues() {
        Object value = this.allIssues.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.allIssues;
            synchronized (atomicReference) {
                value = this.allIssues.get();
                if (value == null) {
                    Collection<Issue> actualValue = this.calculateAllIssues();
                    value = actualValue == null ? this.allIssues : actualValue;
                    this.allIssues.set(value);
                }
            }
        }
        return (Collection)(value == this.allIssues ? null : value);
    }
}

