/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.agile.jira;

import com.fasterxml.jackson.databind.JsonNode;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.Config;
import pl.kaszaq.howfastyouaregoing.agile.IssueBlockedTransition;
import pl.kaszaq.howfastyouaregoing.agile.IssueData;
import pl.kaszaq.howfastyouaregoing.agile.IssueStatusTransition;
import pl.kaszaq.howfastyouaregoing.utils.DateUtils;

class JiraIssueParser {
    private static final Logger LOG = LoggerFactory.getLogger(JiraIssueParser.class);
    private final Map<String, Function<JsonNode, Object>> customFieldsParsers;

    IssueData parseJiraIssue(String jsonIssue, boolean emptyDescriptionAndSummary) throws IOException {
        JsonNode node = Config.OBJECT_MAPPER.readTree(jsonIssue);
        return this.parseJiraIssue(node, emptyDescriptionAndSummary);
    }

    IssueData parseJiraIssue(JsonNode issueNode, boolean emptyDescriptionAndSummary) {
        String description;
        String summary;
        String key = issueNode.path("key").asText(null);
        LOG.debug("Parsing issue {}", (Object)key);
        JsonNode fieldsNode = issueNode.path("fields");
        String creator = fieldsNode.path("creator").path("name").asText(null);
        ZonedDateTime created = DateUtils.parseDate(fieldsNode.path("created").asText(null));
        ZonedDateTime updated = DateUtils.parseDate(fieldsNode.path("updated").asText(null));
        String status = fieldsNode.path("status").path("name").asText(null);
        if (emptyDescriptionAndSummary) {
            summary = "";
            description = "";
        } else {
            summary = fieldsNode.path("summary").asText(null);
            description = fieldsNode.path("description").asText(null);
        }
        TreeSet<IssueStatusTransition> issueStatusTransitions = this.getIssueStatusTransitions(issueNode, status, creator, created);
        TreeSet<IssueBlockedTransition> issueBlockedTransitions = this.getIssueBlockedTransitions(issueNode, status, creator, created);
        JsonNode issueTypeNode = fieldsNode.path("issuetype");
        boolean subtask = issueTypeNode.path("subtask").asBoolean(false);
        String type = issueTypeNode.path("name").asText(null);
        List<String> linkedIssuesKeys = this.getLinkedIssuesKeys(fieldsNode);
        List<String> subtasksKeys = this.getSubtasksKeys(fieldsNode);
        String parentKey = fieldsNode.path("parent").path("key").asText(null);
        String resolution = fieldsNode.path("resolution").path("name").asText(null);
        ArrayList<String> labels = new ArrayList<String>();
        fieldsNode.path("labels").elements().forEachRemaining(labelNode -> labels.add(labelNode.asText(null)));
        ArrayList<String> components = new ArrayList<String>();
        fieldsNode.path("components").elements().forEachRemaining(componentNode -> components.add(componentNode.path("name").asText(null)));
        HashMap<String, Object> customFields = new HashMap<String, Object>();
        this.customFieldsParsers.forEach((k, v) -> {
            Object val = v.apply(fieldsNode);
            if (val != null) {
                customFields.put((String)k, val);
            }
        });
        IssueData issue = IssueData.builder().created(created).creator(creator).summary(summary).description(description).issueStatusTransitions(issueStatusTransitions).issueBlockedTransitions(issueBlockedTransitions).key(key).linkedIssuesKeys(linkedIssuesKeys).parentIssueKey(parentKey).resolution(resolution).subtask(subtask).subtaskKeys(subtasksKeys).status(status).updated(updated).type(type).labels(labels).components(components).customFields(customFields).build();
        return issue;
    }

    private List<String> getSubtasksKeys(JsonNode fieldsNode) {
        ArrayList<String> subtasksKeys = new ArrayList<String>();
        fieldsNode.path("subtasks").elements().forEachRemaining(subtaskNode -> {
            String key = subtaskNode.path("key").asText(null);
            if (key != null) {
                subtasksKeys.add(key);
            }
        });
        return subtasksKeys;
    }

    private List<String> getLinkedIssuesKeys(JsonNode fieldsNode) {
        ArrayList<String> linkedIssuesKeys = new ArrayList<String>();
        fieldsNode.path("issuelinks").elements().forEachRemaining(issueLinkNode -> {
            if (issueLinkNode.has("outwardIssue")) {
                String key = issueLinkNode.path("outwardIssue").path("key").asText(null);
                if (key != null) {
                    linkedIssuesKeys.add(key);
                }
            } else {
                String key = issueLinkNode.path("inwardIssue").path("key").asText(null);
                if (key != null) {
                    linkedIssuesKeys.add(key);
                }
            }
        });
        return linkedIssuesKeys;
    }

    private TreeSet<IssueStatusTransition> getIssueStatusTransitions(JsonNode issueNode, String status, String creator, ZonedDateTime created) {
        String initialStatus;
        TreeSet<IssueStatusTransition> issueStatusTransitions = new TreeSet<IssueStatusTransition>();
        JsonNode changelogNode = issueNode.path("changelog");
        int totalChangelogEntries = changelogNode.path("total").asInt(0);
        if (totalChangelogEntries > 0) {
            changelogNode.path("histories").elements().forEachRemaining(changelogEntry -> {
                String username = changelogEntry.path("author").path("name").asText(null);
                ZonedDateTime createdDate = DateUtils.parseDate(changelogEntry.path("created").asText(null));
                changelogEntry.path("items").elements().forEachRemaining(changelogItem -> {
                    if ("status".equals(changelogItem.path("field").asText(null))) {
                        String fromStatus = changelogItem.path("fromString").asText(null);
                        String toStatus = changelogItem.path("toString").asText(null);
                        IssueStatusTransition issueStatusTransition = new IssueStatusTransition(username, createdDate, fromStatus, toStatus);
                        issueStatusTransitions.add(issueStatusTransition);
                    }
                });
            });
        }
        if (!issueStatusTransitions.isEmpty()) {
            IssueStatusTransition firstTransition = (IssueStatusTransition)issueStatusTransitions.first();
            initialStatus = firstTransition.getFromStatus();
        } else {
            initialStatus = status;
        }
        IssueStatusTransition issueStatusTransition = new IssueStatusTransition(creator, created, null, initialStatus);
        issueStatusTransitions.add(issueStatusTransition);
        return issueStatusTransitions;
    }

    private TreeSet<IssueBlockedTransition> getIssueBlockedTransitions(JsonNode issueNode, String status, String creator, ZonedDateTime created) {
        IssueBlockedTransition firstTransition;
        String initialStatus;
        TreeSet<IssueBlockedTransition> issueBlockedTransitions = new TreeSet<IssueBlockedTransition>();
        JsonNode changelogNode = issueNode.path("changelog");
        int totalChangelogEntries = changelogNode.path("total").asInt(0);
        if (totalChangelogEntries > 0) {
            changelogNode.path("histories").elements().forEachRemaining(changelogEntry -> {
                String username = changelogEntry.path("author").path("name").asText(null);
                ZonedDateTime createdDate = DateUtils.parseDate(changelogEntry.path("created").asText(null));
                changelogEntry.path("items").elements().forEachRemaining(changelogItem -> {
                    if ("Flagged".equals(changelogItem.path("field").asText(null))) {
                        String fromStatus = changelogItem.path("fromString").asText(null);
                        String toStatus = changelogItem.path("toString").asText(null);
                        IssueBlockedTransition issueStatusTransition = new IssueBlockedTransition(username, createdDate, fromStatus, toStatus);
                        issueBlockedTransitions.add(issueStatusTransition);
                    }
                });
            });
        }
        if (!issueBlockedTransitions.isEmpty() && (initialStatus = (firstTransition = (IssueBlockedTransition)issueBlockedTransitions.first()).getFromStatus()) != null) {
            IssueBlockedTransition trans = new IssueBlockedTransition(creator, created, null, initialStatus);
            issueBlockedTransitions.add(trans);
        }
        return issueBlockedTransitions;
    }

    @ConstructorProperties(value={"customFieldsParsers"})
    public JiraIssueParser(Map<String, Function<JsonNode, Object>> customFieldsParsers) {
        this.customFieldsParsers = customFieldsParsers;
    }
}

