/*
 * Decompiled with CFR 0.152.
 */
package pl.kaszaq.howfastyouaregoing.workload;

import java.beans.ConstructorProperties;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kaszaq.howfastyouaregoing.agile.AgileClient;
import pl.kaszaq.howfastyouaregoing.agile.Issue;
import pl.kaszaq.howfastyouaregoing.agile.IssuePredicates;
import pl.kaszaq.howfastyouaregoing.agile.grouping.IssueHierarchyNode;
import pl.kaszaq.howfastyouaregoing.agile.grouping.IssueHierarchyNodeProvider;
import pl.kaszaq.howfastyouaregoing.workload.WorkloadDailyReport;

public class WorkloadReportFactory {
    private static final Logger LOG = LoggerFactory.getLogger(WorkloadReportFactory.class);
    private final AgileClient agileClient;
    private final IssueHierarchyNodeProvider issueHierarchyNodeProvider;

    public Map<LocalDate, WorkloadDailyReport> calculateWorkload(LocalDate from, LocalDate to, String projectId, String ... wipStatuses) {
        HashMap<LocalDate, WorkloadDailyReport> workloadReport = new HashMap<LocalDate, WorkloadDailyReport>();
        List<Issue> issues = this.getValidIssues(projectId);
        LocalDate date = from;
        while (date.isBefore(to) || date.isEqual(to)) {
            WorkloadDailyReport dailyReport = new WorkloadDailyReport();
            issues.stream().filter(IssuePredicates.inStatusOnDay(date, wipStatuses).and(IssuePredicates.isBlockedEntireDay(date).negate())).forEach(issue -> {
                IssueHierarchyNode node = this.issueHierarchyNodeProvider.getHierarchy((Issue)issue);
                Double value = 100.0;
                Set<Issue> leafIssues = node.getLeafsIssues();
                double leafIssuesValue = value / (double)leafIssues.size();
                leafIssues.forEach(i -> dailyReport.reportWorkloadOnIssue((Issue)i, leafIssuesValue));
            });
            workloadReport.put(date, dailyReport);
            date = date.plusDays(1L);
            while (date.getDayOfWeek().getValue() > 5) {
                date = date.plusDays(1L);
            }
        }
        return workloadReport;
    }

    private List<Issue> getValidIssues(String projectId) {
        return this.agileClient.getAgileProject(projectId).getAllIssues().stream().filter(IssuePredicates.inResolution("Won't Fix", "Cannot Reproduce", "Duplicate", "Incomplete", "Not an Issue", "Not Enough Information", "Retest", "Unresolved").negate().and(IssuePredicates.isEpic().negate()).and(IssuePredicates.hasSubtasks().negate())).collect(Collectors.toList());
    }

    @ConstructorProperties(value={"agileClient", "issueHierarchyNodeProvider"})
    public WorkloadReportFactory(AgileClient agileClient, IssueHierarchyNodeProvider issueHierarchyNodeProvider) {
        this.agileClient = agileClient;
        this.issueHierarchyNodeProvider = issueHierarchyNodeProvider;
    }
}

