/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.http.wiremock;

import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.kubie.fluentmocks.common.JsonSerializer;
import pl.kubie.fluentmocks.http.wiremock.WireMockHttpMock;

public record WireMockClient(String host, int port, WireMock wireMock, JsonSerializer serializer) {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WireMockClient.class);

    public WireMockClient(String host, int port, JsonSerializer serializer) {
        this(host, port, new WireMock(host, port), serializer);
    }

    public StubMapping register(MappingBuilder mappingBuilder) {
        log.info("Registering WireMock mapping {} {} {}", new Object[]{this.host, this.port, mappingBuilder});
        return this.wireMock.register(mappingBuilder);
    }

    public void setSingleScenarioState(String scenario, String state) {
        log.info("Setting single scenario {} to state {}", (Object)scenario, (Object)state);
        this.wireMock.setSingleScenarioState(scenario, state);
    }

    public void verifyThat(CountMatchingStrategy expectedCount, RequestPatternBuilder requestPattern) {
        log.info("Verifying that {} requests matching request pattern {}", (Object)expectedCount, (Object)requestPattern);
        this.wireMock.verifyThat(expectedCount, requestPattern);
    }

    public void removeAll(Collection<WireMockHttpMock> mocks) {
        mocks.forEach(mock -> mock.mappings.forEach(mapping -> {
            log.info("Removing stub mapping {}", (Object)mapping.getId());
            this.wireMock.removeStubMapping(mapping);
        }));
        this.wireMock.resetRequests();
    }
}

