/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.http.wiremock;

import com.github.tomakehurst.wiremock.client.CountMatchingStrategy;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.time.Duration;
import java.util.List;
import org.awaitility.Awaitility;
import org.awaitility.core.ThrowingRunnable;
import pl.kubie.fluentmocks.http.api.HttpMock;
import pl.kubie.fluentmocks.http.wiremock.WireMockClient;

public class WireMockHttpMock
implements HttpMock {
    WireMockClient wireMockClient;
    RequestPatternBuilder requestPattern;
    List<StubMapping> mappings;
    Duration awaitTimeout = null;

    public WireMockHttpMock(RequestPatternBuilder requestPattern, List<StubMapping> mappings, WireMockClient wireMockClient) {
        this.requestPattern = requestPattern;
        this.mappings = mappings;
        this.wireMockClient = wireMockClient;
    }

    public HttpMock await() {
        return this.await(Duration.ofSeconds(3L));
    }

    public HttpMock await(Duration timeout) {
        this.awaitTimeout = timeout;
        return this;
    }

    public void verifyNever() {
        this.verifyExactly(0);
    }

    public void verifyOnce() {
        this.verifyExactly(1);
    }

    public void verifyExactly(int times) {
        this.verify(WireMock.exactly((int)times));
    }

    public void verifyAtLeast(int times) {
        this.verify(WireMock.moreThanOrExactly((int)times));
    }

    public void verifyAtMost(int times) {
        this.verify(WireMock.lessThanOrExactly((int)times));
    }

    public void verifyBetween(int atLeast, int atMost) {
        this.verifyAtLeast(atLeast);
        this.verifyAtMost(atMost);
    }

    private void verify(CountMatchingStrategy expectedCount) {
        ThrowingRunnable verification = () -> this.wireMockClient.verifyThat(expectedCount, this.requestPattern);
        if (this.awaitTimeout != null) {
            Awaitility.await().atMost(this.awaitTimeout).untilAsserted(verification);
        } else {
            try {
                verification.run();
            }
            catch (Throwable throwable) {
                throw new AssertionError((Object)throwable);
            }
        }
    }
}

