/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.http.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.matching.RequestPatternBuilder;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.util.MultiValueMap;
import org.springframework.util.MultiValueMapAdapter;
import pl.kubie.fluentmocks.http.api.request.MockHttpRequestSpec;
import pl.kubie.fluentmocks.http.api.request.RequestBody;
import pl.kubie.fluentmocks.http.api.request.UrlSpec;
import pl.kubie.fluentmocks.http.wiremock.WireMockRequestBody;
import pl.kubie.fluentmocks.http.wiremock.WireMockUrl;

public class WireMockHttpRequestSpec
implements MockHttpRequestSpec {
    private final MultiValueMap<String, String> headers = new MultiValueMapAdapter(new HashMap());
    private final Map<String, String> cookies = new HashMap<String, String>();
    private final WireMockUrl url = new WireMockUrl();
    private final WireMockRequestBody body;
    private String method = "ANY";

    public WireMockHttpRequestSpec(WireMockRequestBody body) {
        this.body = body;
    }

    public MockHttpRequestSpec url(Consumer<UrlSpec> onUrl) {
        onUrl.accept(this.url);
        return this;
    }

    public MockHttpRequestSpec method(String method) {
        this.method = method;
        return this;
    }

    public MockHttpRequestSpec header(String key, String value) {
        this.headers.add((Object)key, (Object)value);
        return this;
    }

    public MockHttpRequestSpec cookie(String key, String value) {
        this.cookies.put(key, value);
        return this;
    }

    public MockHttpRequestSpec body(Consumer<RequestBody> bodyCustomization) {
        bodyCustomization.accept((RequestBody)this.body);
        return this;
    }

    public MappingBuilder mapping() {
        MappingBuilder request = WireMock.request((String)this.method, (UrlPattern)WireMock.urlPathTemplate((String)this.url.asString()));
        this.url.pathParams().forEach(entry -> request.withPathParam((String)entry.getKey(), WireMock.equalTo((String)((String)entry.getValue()))));
        this.headers.forEach((header, values) -> request.withHeader(header, WireMock.equalTo((String)((String)values.getFirst()))));
        this.cookies.forEach((cookie, value) -> request.withCookie(cookie, WireMock.equalTo((String)value)));
        this.url.getQueryParams().forEach((param, values) -> request.withQueryParam(param, WireMock.equalTo((String)((String)values.getFirst()))));
        this.body.toContentPattern().ifPresent(arg_0 -> ((MappingBuilder)request).withRequestBody(arg_0));
        return request;
    }

    public RequestPatternBuilder requestPattern() {
        RequestPatternBuilder pattern = RequestPatternBuilder.newRequestPattern((RequestMethod)RequestMethod.fromString((String)this.method), (UrlPattern)WireMock.urlPathTemplate((String)this.url.asString()));
        this.url.pathParams().forEach(entry -> pattern.withPathParam((String)entry.getKey(), WireMock.equalTo((String)((String)entry.getValue()))));
        this.headers.forEach((header, values) -> pattern.withHeader(header, WireMock.equalTo((String)((String)values.getFirst()))));
        this.cookies.forEach((cookie, value) -> pattern.withCookie(cookie, WireMock.equalTo((String)value)));
        this.url.getQueryParams().forEach((param, values) -> pattern.withQueryParam(param, WireMock.equalTo((String)((String)values.getFirst()))));
        this.body.toContentPattern().ifPresent(arg_0 -> ((RequestPatternBuilder)pattern).withRequestBody(arg_0));
        return pattern;
    }
}

