/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.http.wiremock;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import java.time.Duration;
import java.util.function.Consumer;
import pl.kubie.fluentmocks.http.api.response.MockHttpResponseSpec;
import pl.kubie.fluentmocks.http.api.response.ResponseBody;
import pl.kubie.fluentmocks.http.wiremock.WireMockResponseBody;

public class WireMockHttpResponseSpec
implements MockHttpResponseSpec {
    private final ResponseDefinitionBuilder delegate = new ResponseDefinitionBuilder();
    private final WireMockResponseBody body;

    public WireMockHttpResponseSpec(WireMockResponseBody responseBodyDefinition) {
        this.body = responseBodyDefinition;
    }

    public MockHttpResponseSpec body(Consumer<ResponseBody> bodyCustomizer) {
        bodyCustomizer.accept((ResponseBody)this.body);
        return this;
    }

    public MockHttpResponseSpec statusCode(int statusCode) {
        this.delegate.withStatus(statusCode);
        return this;
    }

    public MockHttpResponseSpec header(String name, String value) {
        this.delegate.withHeader(name, new String[]{value});
        return this;
    }

    public MockHttpResponseSpec cookie(String name, String value) {
        return this.header("Set-Cookie", "%s=%s".formatted(name, value));
    }

    public MockHttpResponseSpec delayed(Duration delay) {
        this.delegate.withFixedDelay(Integer.valueOf(Long.valueOf(delay.toMillis()).intValue()));
        return this;
    }

    public ResponseDefinitionBuilder build() {
        this.delegate.withResponseBody(this.body.toWireMockBody());
        return this.delegate;
    }
}

