/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.http.wiremock;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Consumer;
import pl.kubie.fluentmocks.common.FileLoader;
import pl.kubie.fluentmocks.common.JacksonJsonSerializer;
import pl.kubie.fluentmocks.common.JsonSerializer;
import pl.kubie.fluentmocks.http.api.HttpMockSpec;
import pl.kubie.fluentmocks.http.wiremock.WireMockClient;
import pl.kubie.fluentmocks.http.wiremock.WireMockHttpStubber;

public class WireMockHttpStubberConfig {
    private ObjectMapper objectMapper;
    private String host;
    private int port;
    private Consumer<HttpMockSpec> onEach = mock -> {};

    public static WireMockHttpStubberConfig configure() {
        return new WireMockHttpStubberConfig();
    }

    public WireMockHttpStubberConfig objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public WireMockHttpStubberConfig host(String host) {
        this.host = host;
        return this;
    }

    public WireMockHttpStubberConfig port(int port) {
        this.port = port;
        return this;
    }

    public WireMockHttpStubberConfig onEach(Consumer<HttpMockSpec> onEach) {
        this.onEach = onEach;
        return this;
    }

    public WireMockHttpStubber build() {
        JacksonJsonSerializer serializer = new JacksonJsonSerializer(this.objectMapper);
        return new WireMockHttpStubber(new WireMockClient(this.host, this.port, (JsonSerializer)serializer), new FileLoader(), (JsonSerializer)serializer, this.onEach);
    }

    public WireMockHttpStubberConfig local(Integer port) {
        return this.host("localhost").port(port);
    }
}

