/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.http.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import pl.kubie.fluentmocks.http.api.HttpMock;
import pl.kubie.fluentmocks.http.api.HttpMockTimes;
import pl.kubie.fluentmocks.http.wiremock.WireMockClient;
import pl.kubie.fluentmocks.http.wiremock.WireMockHttpMock;
import pl.kubie.fluentmocks.http.wiremock.WireMockHttpRequestSpec;
import pl.kubie.fluentmocks.http.wiremock.WireMockHttpResponseSpec;
import pl.kubie.fluentmocks.http.wiremock.WireMockScenarioHttpTimes;
import pl.kubie.fluentmocks.http.wiremock.WireMockStubbingReporter;

public final class WireMockHttpTimes
implements HttpMockTimes {
    private final WireMockHttpRequestSpec request;
    private final WireMockHttpResponseSpec response;
    private final WireMockClient wireMock;
    private final WireMockStubbingReporter reporter;
    private final Consumer<WireMockHttpMock> onMockCreated;

    public HttpMock unlimited() {
        MappingBuilder requestMapping = this.request.mapping();
        ResponseDefinitionBuilder responseDefinition = this.response.build();
        StubMapping mapping = this.wireMock.register(requestMapping.willReturn(responseDefinition));
        this.reporter.report(mapping);
        WireMockHttpMock mock = new WireMockHttpMock(this.request.requestPattern(), List.of(mapping), this.wireMock);
        this.onMockCreated.accept(mock);
        return mock;
    }

    public HttpMock exactly(int times) {
        WireMockHttpMock mock = new WireMockScenarioHttpTimes(this.request, this.response, this.wireMock).times(times);
        this.onMockCreated.accept(mock);
        return mock;
    }

    public HttpMock once() {
        return this.exactly(1);
    }

    @Generated
    public WireMockHttpTimes(WireMockHttpRequestSpec request, WireMockHttpResponseSpec response, WireMockClient wireMock, WireMockStubbingReporter reporter, Consumer<WireMockHttpMock> onMockCreated) {
        this.request = request;
        this.response = response;
        this.wireMock = wireMock;
        this.reporter = reporter;
        this.onMockCreated = onMockCreated;
    }

    @Generated
    public WireMockHttpRequestSpec getRequest() {
        return this.request;
    }

    @Generated
    public WireMockHttpResponseSpec getResponse() {
        return this.response;
    }

    @Generated
    public WireMockClient getWireMock() {
        return this.wireMock;
    }

    @Generated
    public WireMockStubbingReporter getReporter() {
        return this.reporter;
    }

    @Generated
    public Consumer<WireMockHttpMock> getOnMockCreated() {
        return this.onMockCreated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WireMockHttpTimes)) {
            return false;
        }
        WireMockHttpTimes other = (WireMockHttpTimes)o;
        WireMockHttpRequestSpec this$request = this.getRequest();
        WireMockHttpRequestSpec other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        WireMockHttpResponseSpec this$response = this.getResponse();
        WireMockHttpResponseSpec other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        WireMockClient this$wireMock = this.getWireMock();
        WireMockClient other$wireMock = other.getWireMock();
        if (this$wireMock == null ? other$wireMock != null : !((Object)this$wireMock).equals(other$wireMock)) {
            return false;
        }
        WireMockStubbingReporter this$reporter = this.getReporter();
        WireMockStubbingReporter other$reporter = other.getReporter();
        if (this$reporter == null ? other$reporter != null : !((Object)this$reporter).equals(other$reporter)) {
            return false;
        }
        Consumer<WireMockHttpMock> this$onMockCreated = this.getOnMockCreated();
        Consumer<WireMockHttpMock> other$onMockCreated = other.getOnMockCreated();
        return !(this$onMockCreated == null ? other$onMockCreated != null : !this$onMockCreated.equals(other$onMockCreated));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WireMockHttpRequestSpec $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        WireMockHttpResponseSpec $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        WireMockClient $wireMock = this.getWireMock();
        result = result * 59 + ($wireMock == null ? 43 : ((Object)$wireMock).hashCode());
        WireMockStubbingReporter $reporter = this.getReporter();
        result = result * 59 + ($reporter == null ? 43 : ((Object)$reporter).hashCode());
        Consumer<WireMockHttpMock> $onMockCreated = this.getOnMockCreated();
        result = result * 59 + ($onMockCreated == null ? 43 : $onMockCreated.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WireMockHttpTimes(request=" + String.valueOf(this.getRequest()) + ", response=" + String.valueOf(this.getResponse()) + ", wireMock=" + String.valueOf(this.getWireMock()) + ", reporter=" + String.valueOf(this.getReporter()) + ", onMockCreated=" + String.valueOf(this.getOnMockCreated()) + ")";
    }
}

