/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.http.wiremock;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import pl.kubie.fluentmocks.common.AbstractRequestBody;
import pl.kubie.fluentmocks.common.FileLoader;
import pl.kubie.fluentmocks.common.JsonSerializer;
import pl.kubie.fluentmocks.common.PayloadFormat;

public class WireMockRequestBody
extends AbstractRequestBody {
    public WireMockRequestBody(FileLoader fileLoader, JsonSerializer serializer) {
        super(fileLoader, serializer);
    }

    public Optional<ContentPattern<?>> toContentPattern() {
        return switch (this.format) {
            default -> throw new MatchException(null, null);
            case PayloadFormat.EMPTY -> Optional.empty();
            case PayloadFormat.RAW_BYTES -> Optional.of(WireMock.binaryEqualTo((byte[])this.bytes));
            case PayloadFormat.RAW -> Optional.of(WireMock.equalTo((String)this.asString()));
            case PayloadFormat.JSON -> Optional.of(WireMock.equalToJson((String)this.asString(), (boolean)false, (boolean)true));
        };
    }

    @NotNull
    private String asString() {
        return new String(this.bytes, StandardCharsets.UTF_8);
    }
}

