/*
 * Decompiled with CFR 0.152.
 */
package pl.kubie.fluentmocks.http.wiremock;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ScenarioMappingBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import pl.kubie.fluentmocks.http.wiremock.WireMockClient;
import pl.kubie.fluentmocks.http.wiremock.WireMockHttpMock;
import pl.kubie.fluentmocks.http.wiremock.WireMockHttpRequestSpec;
import pl.kubie.fluentmocks.http.wiremock.WireMockHttpResponseSpec;

public final class WireMockScenarioHttpTimes {
    private final WireMockHttpRequestSpec request;
    private final WireMockHttpResponseSpec response;
    private final WireMockClient wireMockClient;

    public WireMockHttpMock times(int times) {
        String scenario = UUID.randomUUID().toString();
        List<StubMapping> mappings = IntStream.range(0, times).mapToObj(i -> this.registerStep(scenario, WireMockScenarioHttpTimes.step(i), WireMockScenarioHttpTimes.step(i + 1))).toList();
        StubMapping finalMapping = this.registerFinalStep(scenario, WireMockScenarioHttpTimes.step(times));
        this.wireMockClient.setSingleScenarioState(scenario, "step-0");
        return new WireMockHttpMock(this.request.requestPattern(), Stream.concat(mappings.stream(), Stream.of(finalMapping)).toList(), this.wireMockClient);
    }

    private StubMapping registerStep(String scenario, String source, String target) {
        ScenarioMappingBuilder requestMapping = this.request.mapping().inScenario(scenario).whenScenarioStateIs(source).willSetStateTo(target).willReturn(this.response.build());
        return this.wireMockClient.register((MappingBuilder)requestMapping);
    }

    private StubMapping registerFinalStep(String scenario, String step) {
        ScenarioMappingBuilder requestMapping = this.request.mapping().inScenario(scenario).whenScenarioStateIs(step).willSetStateTo("Completed").willReturn(WireMock.aResponse().withStatus(404));
        return this.wireMockClient.register((MappingBuilder)requestMapping);
    }

    private static String step(int i) {
        return "step-%s".formatted(i);
    }

    @Generated
    public WireMockScenarioHttpTimes(WireMockHttpRequestSpec request, WireMockHttpResponseSpec response, WireMockClient wireMockClient) {
        this.request = request;
        this.response = response;
        this.wireMockClient = wireMockClient;
    }

    @Generated
    public WireMockHttpRequestSpec getRequest() {
        return this.request;
    }

    @Generated
    public WireMockHttpResponseSpec getResponse() {
        return this.response;
    }

    @Generated
    public WireMockClient getWireMockClient() {
        return this.wireMockClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WireMockScenarioHttpTimes)) {
            return false;
        }
        WireMockScenarioHttpTimes other = (WireMockScenarioHttpTimes)o;
        WireMockHttpRequestSpec this$request = this.getRequest();
        WireMockHttpRequestSpec other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        WireMockHttpResponseSpec this$response = this.getResponse();
        WireMockHttpResponseSpec other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        WireMockClient this$wireMockClient = this.getWireMockClient();
        WireMockClient other$wireMockClient = other.getWireMockClient();
        return !(this$wireMockClient == null ? other$wireMockClient != null : !((Object)this$wireMockClient).equals(other$wireMockClient));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        WireMockHttpRequestSpec $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        WireMockHttpResponseSpec $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        WireMockClient $wireMockClient = this.getWireMockClient();
        result = result * 59 + ($wireMockClient == null ? 43 : ((Object)$wireMockClient).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "WireMockScenarioHttpTimes(request=" + String.valueOf(this.getRequest()) + ", response=" + String.valueOf(this.getResponse()) + ", wireMockClient=" + String.valueOf(this.getWireMockClient()) + ")";
    }
}

