/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.ajax.config;

import com.github.mati1979.play.soyplugin.ajax.SoyAjaxController;
import com.github.mati1979.play.soyplugin.ajax.allowedurls.DefaultSoyAllowedUrlsResolver;
import com.github.mati1979.play.soyplugin.ajax.allowedurls.SoyAllowedUrls;
import com.github.mati1979.play.soyplugin.ajax.allowedurls.SoyAllowedUrlsResolver;
import com.github.mati1979.play.soyplugin.ajax.auth.AuthManager;
import com.github.mati1979.play.soyplugin.ajax.auth.ConfigurableAuthManager;
import com.github.mati1979.play.soyplugin.ajax.auth.PermissableAuthManager;
import com.github.mati1979.play.soyplugin.ajax.hash.HashFileGenerator;
import com.github.mati1979.play.soyplugin.ajax.hash.MD5HashFileGenerator;
import com.github.mati1979.play.soyplugin.ajax.process.OutputProcessor;
import com.github.mati1979.play.soyplugin.ajax.process.google.GoogleClosureOutputProcessor;
import com.github.mati1979.play.soyplugin.bundle.SoyMsgBundleResolver;
import com.github.mati1979.play.soyplugin.compile.TofuCompiler;
import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.locale.LocaleProvider;
import com.github.mati1979.play.soyplugin.spring.PlaySoyConfig;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.google.common.collect.Lists;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import play.core.enhancers.PropertiesEnhancer;

@Configuration
@Import(value={PlaySoyConfig.class})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PlaySoyViewAjaxConfig {
    @Bean(initMethod="init")
    public HashFileGenerator soyMd5HashFileGenerator(SoyAllowedUrls soyAllowedUrls, SoyViewConf soyViewConf) {
        return new MD5HashFileGenerator(soyAllowedUrls, soyViewConf);
    }

    @Bean(initMethod="init")
    public SoyAjaxController soyAjaxController(AuthManager authManager, LocaleProvider localeProvider, TemplateFilesResolver templateFilesResolver, TofuCompiler tofuCompiler, SoyMsgBundleResolver soyMsgBundleResolver, SoyViewConf soyViewConf) {
        return new SoyAjaxController(authManager, localeProvider, soyMsgBundleResolver, tofuCompiler, templateFilesResolver, Lists.newArrayList((Object[])new OutputProcessor[]{new GoogleClosureOutputProcessor(soyViewConf)}), soyViewConf);
    }

    @Bean
    public SoyAllowedUrlsResolver soyAllowedUrlsResolver(TemplateFilesResolver templateFilesResolver, SoyViewConf soyViewConf) {
        return new DefaultSoyAllowedUrlsResolver(templateFilesResolver, soyViewConf);
    }

    @Bean
    public SoyAllowedUrls soyAllowedUrls(SoyAllowedUrlsResolver soyAllowedUrlsResolver) {
        return soyAllowedUrlsResolver.allowedUrls();
    }

    @Bean
    public AuthManager soyAuthManager(SoyAllowedUrls soyAllowedUrls) {
        if (soyAllowedUrls.isEnabledSecurity()) {
            return new ConfigurableAuthManager(soyAllowedUrls.urls());
        }
        return new PermissableAuthManager();
    }
}

