/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.global.runtime;

import com.github.mati1979.play.soyplugin.global.runtime.GlobalRuntimeModelResolver;
import com.github.mati1979.play.soyplugin.global.runtime.RuntimeDataResolver;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.template.soy.data.SoyMapData;
import java.util.List;
import java.util.Map;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DefaultGlobalRuntimeModelResolver
implements GlobalRuntimeModelResolver {
    private static final Logger.ALogger logger = Logger.of(DefaultGlobalRuntimeModelResolver.class);
    private List<RuntimeDataResolver> resolvers = Lists.newArrayList();
    private List<RuntimeDataResolver> userResolvers = Lists.newArrayList();

    public DefaultGlobalRuntimeModelResolver(List<RuntimeDataResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public DefaultGlobalRuntimeModelResolver(List<RuntimeDataResolver> resolvers, List<RuntimeDataResolver> userResolvers) {
        this.resolvers = resolvers;
        this.userResolvers = userResolvers;
    }

    @Override
    public Optional<SoyMapData> resolveData(Http.Request request, Http.Response response, Map<String, ? extends Object> model) {
        SoyMapData root = new SoyMapData();
        for (RuntimeDataResolver runtimeDataResolver : this.resolvers) {
            logger.debug("resolving:{}", new Object[]{runtimeDataResolver});
            runtimeDataResolver.resolveData(request, response, model, root);
        }
        for (RuntimeDataResolver runtimeDataResolver : this.userResolvers) {
            logger.debug("user data resolving:{}", new Object[]{runtimeDataResolver});
            runtimeDataResolver.resolveData(request, response, model, root);
        }
        return Optional.of((Object)root);
    }
}

