/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.ajax;

import com.github.mati1979.play.soyplugin.ajax.auth.AuthManager;
import com.github.mati1979.play.soyplugin.ajax.auth.PermissableAuthManager;
import com.github.mati1979.play.soyplugin.ajax.process.OutputProcessor;
import com.github.mati1979.play.soyplugin.ajax.utils.I18nUtils;
import com.github.mati1979.play.soyplugin.ajax.utils.PathUtils;
import com.github.mati1979.play.soyplugin.bundle.EmptySoyMsgBundleResolver;
import com.github.mati1979.play.soyplugin.bundle.SoyMsgBundleResolver;
import com.github.mati1979.play.soyplugin.compile.EmptyTofuCompiler;
import com.github.mati1979.play.soyplugin.compile.TofuCompiler;
import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.locale.EmptyLocaleProvider;
import com.github.mati1979.play.soyplugin.locale.LocaleProvider;
import com.github.mati1979.play.soyplugin.template.EmptyTemplateFilesResolver;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.template.soy.msgs.SoyMsgBundle;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.springframework.util.StringUtils;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
@ThreadSafe
public class SoyAjaxController
extends Controller {
    private static final Logger.ALogger logger = Logger.of(SoyAjaxController.class);
    private static final int DEF_CACHE_MAX_SIZE = 10000;
    private static final String DEF_TIME_UNIT = "DAYS";
    private static final int DEF_EXPIRE_AFTER_WRITE = 1;
    private int cacheMaxSize = 10000;
    private int expireAfterWrite = 1;
    private String expireAfterWriteUnit = "DAYS";
    private Cache<String, Map<String, String>> cachedJsTemplates = CacheBuilder.newBuilder().expireAfterWrite((long)this.expireAfterWrite, TimeUnit.valueOf(this.expireAfterWriteUnit)).maximumSize((long)this.cacheMaxSize).build();
    private TemplateFilesResolver templateFilesResolver = new EmptyTemplateFilesResolver();
    private TofuCompiler tofuCompiler = new EmptyTofuCompiler();
    private SoyMsgBundleResolver soyMsgBundleResolver = new EmptySoyMsgBundleResolver();
    private LocaleProvider localeProvider = new EmptyLocaleProvider();
    private List<OutputProcessor> outputProcessors = new ArrayList<OutputProcessor>();
    private AuthManager authManager = new PermissableAuthManager();
    private SoyViewConf soyViewConf;

    public SoyAjaxController(AuthManager authManager, LocaleProvider localeProvider, SoyMsgBundleResolver soyMsgBundleResolver, TofuCompiler tofuCompiler, TemplateFilesResolver templateFilesResolver, List<OutputProcessor> outputProcessors, SoyViewConf soyViewConf) {
        this.authManager = authManager;
        this.localeProvider = localeProvider;
        this.soyMsgBundleResolver = soyMsgBundleResolver;
        this.tofuCompiler = tofuCompiler;
        this.templateFilesResolver = templateFilesResolver;
        this.outputProcessors = outputProcessors;
        this.soyViewConf = soyViewConf;
    }

    public void init() {
        logger.info("ajax controller init...");
        this.cachedJsTemplates = CacheBuilder.newBuilder().expireAfterWrite((long)this.expireAfterWrite, TimeUnit.valueOf(this.expireAfterWriteUnit)).maximumSize((long)this.cacheMaxSize).build();
        logger.info("ajax controller init complete.");
    }

    public Result compile(String hash, List<String> file, String locale, boolean disableProcessors) throws IOException {
        return this.compileJs(file.toArray(new String[0]), hash, new Boolean(disableProcessors), locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result compileJs(String[] templateFileNames, String hash, boolean disableProcessors, String locale) {
        Preconditions.checkNotNull((Object)this.templateFilesResolver, (Object)"templateFilesResolver cannot be null");
        logger.debug("ajax controller compileJs,templates:{}, hash:{}, disableProcessors:{}, locale:{}", new Object[]{templateFileNames, hash, disableProcessors, locale});
        try {
            Optional<String> template;
            if (!this.soyViewConf.globalHotReloadMode() && (template = this.extractAndCombineAll(hash, templateFileNames)).isPresent()) {
                return this.prepareResponseFor(template.get(), disableProcessors);
            }
            Map<URL, String> compiledTemplates = this.compileTemplates(templateFileNames, SoyAjaxController.request(), locale);
            Optional<String> allCompiledTemplates = this.concatCompiledTemplates(compiledTemplates);
            if (!allCompiledTemplates.isPresent()) {
                return SoyAjaxController.notFound((String)"Template file(s) could not be resolved.");
            }
            if (!this.soyViewConf.globalHotReloadMode()) {
                Cache<String, Map<String, String>> cache = this.cachedJsTemplates;
                synchronized (cache) {
                    ConcurrentHashMap<String, String> map = (ConcurrentHashMap<String, String>)this.cachedJsTemplates.getIfPresent((Object)hash);
                    if (map == null) {
                        map = new ConcurrentHashMap<String, String>();
                    } else {
                        map.put(PathUtils.arrayToPath(templateFileNames), allCompiledTemplates.get());
                    }
                    this.cachedJsTemplates.put((Object)hash, map);
                }
            }
            return this.prepareResponseFor(allCompiledTemplates.get(), disableProcessors);
        }
        catch (Exception ex) {
            return SoyAjaxController.internalServerError((String)ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<String> extractAndCombineAll(String hash, String[] templateFileNames) throws IOException {
        Cache<String, Map<String, String>> cache = this.cachedJsTemplates;
        synchronized (cache) {
            Map map = (Map)this.cachedJsTemplates.getIfPresent((Object)hash);
            if (map != null) {
                String template = (String)map.get(PathUtils.arrayToPath(templateFileNames));
                return Optional.ofNullable(template);
            }
        }
        return Optional.empty();
    }

    private Map<URL, String> compileTemplates(String[] templateFileNames, Http.Request request, String locale) {
        HashMap<URL, String> map = new HashMap<URL, String>();
        for (String templateFileName : templateFileNames) {
            try {
                Optional<URL> templateUrl = this.templateFilesResolver.resolve(templateFileName);
                if (!templateUrl.isPresent()) {
                    throw new RuntimeException("File not found:" + templateFileName);
                }
                if (!this.authManager.isAllowed(templateFileName)) {
                    throw new RuntimeException("no permission to compile:" + templateFileName);
                }
                Optional<String> templateContent = this.compileTemplateAndAssertSuccess(request, templateUrl, locale);
                if (!templateContent.isPresent()) {
                    throw new RuntimeException("file cannot be compiled:" + templateUrl);
                }
                map.put(templateUrl.get(), templateContent.get());
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to find file:" + templateFileName + ".soy");
            }
        }
        return map;
    }

    private Optional<String> concatCompiledTemplates(Map<URL, String> compiledTemplates) throws IOException, SecurityException {
        if (compiledTemplates.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder allJsTemplates = new StringBuilder();
        for (String compiledTemplate : compiledTemplates.values()) {
            allJsTemplates.append(compiledTemplate);
        }
        return Optional.of(allJsTemplates.toString());
    }

    private Result prepareResponseFor(String templateContent, boolean disableProcessors) throws IOException {
        SoyAjaxController.response().getHeaders().put("Content-Type", "text/javascript; charset=" + this.soyViewConf.globalEncoding());
        SoyAjaxController.response().getHeaders().put("Cache-Control", this.soyViewConf.globalHotReloadMode() ? "no-cache" : this.soyViewConf.ajaxCacheControl());
        logger.debug("Content-Type:" + (String)SoyAjaxController.response().getHeaders().get("Content-Type"));
        logger.debug("Cache-Control:" + (String)SoyAjaxController.response().getHeaders().get("Cache-Control"));
        if (StringUtils.hasText((String)this.soyViewConf.ajaxExpireHeaders()) && !this.soyViewConf.globalHotReloadMode()) {
            SoyAjaxController.response().getHeaders().put("Expires", this.soyViewConf.ajaxExpireHeaders());
        }
        logger.debug("Expires:" + (String)SoyAjaxController.response().getHeaders().get("Expires"));
        if (disableProcessors) {
            logger.debug("output post-processors are disabled.");
            return SoyAjaxController.ok((String)templateContent);
        }
        String processTemplate = templateContent;
        try {
            for (OutputProcessor outputProcessor : this.outputProcessors) {
                StringWriter writer = new StringWriter();
                outputProcessor.process(new StringReader(templateContent), writer);
                processTemplate = writer.getBuffer().toString();
            }
            return SoyAjaxController.ok((String)processTemplate);
        }
        catch (Exception ex) {
            return SoyAjaxController.internalServerError((String)"Unable to process template!");
        }
    }

    private Optional<String> compileTemplateAndAssertSuccess(Http.Request request, Optional<URL> templateFile, String locale) throws IOException {
        Preconditions.checkNotNull((Object)this.localeProvider, (Object)"localeProvider cannot be null");
        Preconditions.checkNotNull((Object)this.soyMsgBundleResolver, (Object)"soyMsgBundleResolver cannot be null");
        Preconditions.checkNotNull((Object)this.tofuCompiler, (Object)"tofuCompiler cannot be null");
        if (!templateFile.isPresent()) {
            return Optional.empty();
        }
        Optional<Locale> localeOptional = Optional.ofNullable(I18nUtils.getLocaleFromString(locale));
        if (!localeOptional.isPresent()) {
            localeOptional = this.localeProvider.resolveLocale(request);
        }
        Optional<SoyMsgBundle> soyMsgBundle = this.soyMsgBundleResolver.resolve(localeOptional);
        Optional<String> compiledTemplate = this.tofuCompiler.compileToJsSrc((URL)templateFile.orElse(null), (SoyMsgBundle)soyMsgBundle.orElse(null));
        return compiledTemplate;
    }
}

