/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.ajax.allowedurls;

import com.github.mati1979.play.soyplugin.ajax.allowedurls.SoyAllowedUrls;
import com.github.mati1979.play.soyplugin.ajax.allowedurls.SoyAllowedUrlsResolver;
import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DefaultSoyAllowedUrlsResolver
implements SoyAllowedUrlsResolver {
    private static final Logger.ALogger logger = Logger.of(DefaultSoyAllowedUrlsResolver.class);
    private final TemplateFilesResolver templateFilesResolver;
    private final SoyViewConf soyViewConf;

    public DefaultSoyAllowedUrlsResolver(TemplateFilesResolver templateFilesResolver, SoyViewConf soyViewConf) {
        this.templateFilesResolver = templateFilesResolver;
        this.soyViewConf = soyViewConf;
    }

    @Override
    public SoyAllowedUrls allowedUrls() {
        List<String> templateNames = Arrays.asList(this.soyViewConf.ajaxAllowedUrls().split(","));
        Map<String, Supplier<Optional<URL>>> cache = this.urlsCache(this.templateFilesResolver, templateNames);
        ImmutableList urls = FluentIterable.from(templateNames).filter(templateName -> ((Optional)((Supplier)cache.get(templateName)).get()).isPresent()).transform(templateName -> (URL)((Optional)((Supplier)cache.get(templateName)).get()).get()).toList();
        logger.debug("allowedUrls:" + urls);
        return new SoyAllowedUrls((List<URL>)urls, templateNames, this.soyViewConf.ajaxSecurityEnabled());
    }

    private Map<String, Supplier<Optional<URL>>> urlsCache(TemplateFilesResolver templateFilesResolver, List<String> templateNames) {
        HashMap<String, Supplier<Optional<URL>>> cache = new HashMap<String, Supplier<Optional<URL>>>();
        for (String templateName : templateNames) {
            Supplier memoize = Suppliers.memoize(() -> {
                try {
                    return templateFilesResolver.resolve(templateName);
                }
                catch (IOException e) {
                    return Optional.empty();
                }
            });
            cache.put(templateName, (Supplier<Optional<URL>>)memoize);
        }
        return cache;
    }
}

