/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.ajax.process.yahoo;

import com.github.mati1979.play.soyplugin.ajax.process.OutputProcessor;
import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class YahooOutputProcessor
implements OutputProcessor {
    private static final Logger.ALogger logger = Logger.of(YahooOutputProcessor.class);
    private int linebreakpos = -1;
    boolean munge = false;
    boolean verbose = false;
    boolean preserveAllSemiColons = true;
    boolean disableOptimizations = false;
    private boolean logWarn = false;
    private boolean logError = true;

    @Override
    public void process(Reader reader, Writer writer) throws IOException {
        logger.debug("yahoo processor processing...");
        JavaScriptCompressor javaScriptCompressor = new JavaScriptCompressor(reader, new ErrorReporter(){

            public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
                if (!YahooOutputProcessor.this.logWarn) {
                    return;
                }
                if (line < 0) {
                    logger.warn("\n[WARNING] " + message);
                } else {
                    logger.warn("\n[WARNING] " + line + ':' + lineOffset + ':' + message);
                }
            }

            public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
                if (!YahooOutputProcessor.this.logError) {
                    return;
                }
                if (line < 0) {
                    logger.error("\n[ERROR] " + message);
                } else {
                    logger.error("\n[ERROR] " + line + ':' + lineOffset + ':' + message);
                }
            }

            public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                this.error(message, sourceName, line, lineSource, lineOffset);
                return new EvaluatorException(message);
            }
        });
        javaScriptCompressor.compress(writer, this.linebreakpos, this.munge, this.verbose, this.preserveAllSemiColons, this.disableOptimizations);
    }

    public void setMunge(boolean munge) {
        this.munge = munge;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setPreserveAllSemiColons(boolean preserveAllSemiColons) {
        this.preserveAllSemiColons = preserveAllSemiColons;
    }

    public void setDisableOptimizations(boolean disableOptimizations) {
        this.disableOptimizations = disableOptimizations;
    }

    public void setLogWarn(boolean logWarn) {
        this.logWarn = logWarn;
    }

    public void setLogError(boolean logError) {
        this.logError = logError;
    }

    public void setLinebreakpos(int linebreakpos) {
        this.linebreakpos = linebreakpos;
    }
}

