/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.ajax.process.google;

import com.github.mati1979.play.soyplugin.ajax.process.OutputProcessor;
import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.google.common.collect.Lists;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.ClosureCodingConvention;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.logging.Level;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.springframework.util.StringUtils;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
@ThreadSafe
public class GoogleClosureOutputProcessor
implements OutputProcessor {
    private static final Logger.ALogger logger = Logger.of(GoogleClosureOutputProcessor.class);
    private CompilationLevel compilationLevel = CompilationLevel.SIMPLE_OPTIMIZATIONS;
    private boolean logCompilerErrors = true;
    private boolean logCompilerWarnings = false;
    private SoyViewConf soyViewConf;

    public GoogleClosureOutputProcessor(SoyViewConf soyViewConf) {
        this.soyViewConf = soyViewConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Reader reader, Writer writer) throws IOException {
        logger.debug("google closure processing...");
        String originalJsSourceCode = IOUtils.toString((Reader)reader);
        try {
            Compiler.setLoggingLevel((Level)Level.SEVERE);
            Compiler compiler = new Compiler();
            CompilerOptions compilerOptions = this.newCompilerOptions();
            this.compilationLevel.setOptionsForCompilationLevel(compilerOptions);
            compiler.disableThreads();
            compiler.initOptions(compilerOptions);
            SourceFile input = SourceFile.fromInputStream((String)"dummy.js", (InputStream)new ByteArrayInputStream(originalJsSourceCode.getBytes(this.soyViewConf.globalEncoding())));
            Result result = compiler.compile((List)Lists.newArrayList(), (List)Lists.newArrayList((Object[])new SourceFile[]{input}), compilerOptions);
            this.logWarningsAndErrors(result);
            boolean origFallback = false;
            if (result.success) {
                String minifiedJsSourceCode = compiler.toSource();
                if (StringUtils.isEmpty((Object)minifiedJsSourceCode)) {
                    origFallback = true;
                } else {
                    writer.write(minifiedJsSourceCode);
                }
            } else {
                origFallback = true;
            }
            if (origFallback) {
                writer.write(originalJsSourceCode);
            }
        }
        finally {
            reader.close();
            writer.close();
        }
    }

    private void logWarningsAndErrors(Result result) {
        if (this.logCompilerErrors && result.errors.length > 0) {
            for (JSError jsError : result.errors) {
                logger.warn("js error:" + jsError.toString());
            }
        }
        if (this.logCompilerWarnings && result.warnings.length > 0) {
            for (JSError jsError : result.warnings) {
                logger.warn("js warn:" + jsError.toString());
            }
        }
    }

    protected CompilerOptions newCompilerOptions() {
        CompilerOptions options = new CompilerOptions();
        options.setCodingConvention((CodingConvention)new ClosureCodingConvention());
        options.setOutputCharset(this.soyViewConf.globalEncoding());
        options.setWarningLevel(DiagnosticGroups.CHECK_VARIABLES, CheckLevel.WARNING);
        return options;
    }
}

