/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.compile;

import com.github.mati1979.play.soyplugin.compile.TofuCompiler;
import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.global.compile.CompileTimeGlobalModelResolver;
import com.github.mati1979.play.soyplugin.global.compile.EmptyCompileTimeGlobalModelResolver;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.SoyTofuOptions;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DefaultTofuCompiler
implements TofuCompiler {
    private static final Logger.ALogger logger = Logger.of(DefaultTofuCompiler.class);
    private CompileTimeGlobalModelResolver compileTimeGlobalModelResolver = new EmptyCompileTimeGlobalModelResolver();
    private SoyJsSrcOptions soyJsSrcOptions = new SoyJsSrcOptions();
    private SoyTofuOptions soyTofuOptions = new SoyTofuOptions();
    private SoyViewConf soyViewConf;

    public DefaultTofuCompiler(CompileTimeGlobalModelResolver compileTimeGlobalModelResolver, SoyViewConf soyViewConf, SoyJsSrcOptions soyJsSrcOptions, SoyTofuOptions soyTofuOptions) {
        this.compileTimeGlobalModelResolver = compileTimeGlobalModelResolver;
        this.soyViewConf = soyViewConf;
        this.soyJsSrcOptions = soyJsSrcOptions;
        this.soyTofuOptions = soyTofuOptions;
    }

    @Override
    public SoyTofu compile(@Nullable Collection<URL> urls) throws IOException {
        Preconditions.checkNotNull((Object)"compileTimeGlobalModelResolver", (Object)this.compileTimeGlobalModelResolver);
        if (urls == null || urls.isEmpty()) {
            throw new IOException("Unable to compile, no urls found");
        }
        logger.debug("SoyTofu compilation of templates:" + urls.size());
        long time1 = System.currentTimeMillis();
        SoyFileSet.Builder sfsBuilder = new SoyFileSet.Builder();
        for (URL url : urls) {
            sfsBuilder.add(url);
        }
        this.addCompileTimeGlobalModel(sfsBuilder);
        SoyFileSet soyFileSet = sfsBuilder.build();
        SoyTofuOptions soyTofuOptions = this.createSoyTofuOptions();
        SoyTofu soyTofu = soyFileSet.compileToTofu(soyTofuOptions);
        long time2 = System.currentTimeMillis();
        logger.debug("SoyTofu compilation complete." + (time2 - time1) + " ms");
        return soyTofu;
    }

    private void addCompileTimeGlobalModel(SoyFileSet.Builder sfsBuilder) {
        Map mapData;
        Optional<SoyMapData> soyMapData = this.compileTimeGlobalModelResolver.resolveData();
        if (soyMapData.isPresent() && (mapData = soyMapData.get().asMap()).size() > 0) {
            logger.debug("Setting compile time globals, entries number:" + mapData.size());
            sfsBuilder.setCompileTimeGlobals(mapData);
        }
    }

    private SoyTofuOptions createSoyTofuOptions() {
        SoyTofuOptions soyTofuOptions = new SoyTofuOptions();
        soyTofuOptions.setUseCaching(!this.soyViewConf.globalHotReloadMode());
        return soyTofuOptions;
    }

    @Override
    public final Optional<String> compileToJsSrc(@Nullable URL url, @Nullable SoyMsgBundle soyMsgBundle) {
        if (url == null) {
            return Optional.empty();
        }
        Collection<String> compiledTemplates = this.compileToJsSrc(Lists.newArrayList((Object[])new URL[]{url}), soyMsgBundle);
        if (compiledTemplates.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofNullable(compiledTemplates.iterator().next());
    }

    @Override
    public Collection<String> compileToJsSrc(Collection<URL> templates, @Nullable SoyMsgBundle soyMsgBundle) {
        Preconditions.checkNotNull((Object)"soyJsSrcOptions", (Object)this.soyJsSrcOptions);
        logger.debug("SoyJavaScript compilation of template:" + templates);
        long time1 = System.currentTimeMillis();
        SoyFileSet soyFileSet = this.buildSoyFileSetFrom(templates);
        List compiled = soyFileSet.compileToJsSrc(this.soyJsSrcOptions, soyMsgBundle);
        long time2 = System.currentTimeMillis();
        logger.debug("SoyJavaScript compilation complete." + (time2 - time1) + " ms");
        return compiled;
    }

    private SoyFileSet buildSoyFileSetFrom(Collection<URL> urls) {
        logger.debug("Building soy file set from urls.count:" + urls.size());
        SoyFileSet.Builder builder = new SoyFileSet.Builder();
        for (URL url : urls) {
            builder.setAllowExternalCalls(true);
            builder.add(url);
        }
        this.addCompileTimeGlobalModel(builder);
        return builder.build();
    }

    public SoyJsSrcOptions getSoyJsSrcOptions() {
        return this.soyJsSrcOptions;
    }

    public SoyTofuOptions getSoyTofuOptions() {
        return this.soyTofuOptions;
    }
}

