/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.exception;

import com.google.template.soy.base.SoySyntaxException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import play.api.PlayException;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ExceptionInTemplate
extends PlayException.ExceptionSource {
    private static final Pattern PATTERN = Pattern.compile("^.+\\[line\\040(\\d{1,3}),\\040column\\040(\\d{1,3})\\].+$");
    private Optional<File> templateFile = Optional.empty();
    private Integer line;
    private Integer position;
    private String fileAsString = "";

    public ExceptionInTemplate(Optional<File> templateFile, String viewName, Integer line, Integer position, String description, Throwable cause) {
        super("Syntax error in soy template: " + viewName, description, cause);
        this.templateFile = templateFile;
        this.line = line;
        this.position = position;
        this.fileAsString = this.fileAsString(templateFile);
    }

    public Integer line() {
        return this.line;
    }

    public Integer position() {
        return this.position;
    }

    public String input() {
        return this.fileAsString;
    }

    public String sourceName() {
        return this.templateFile.map(input -> input.getAbsolutePath()).orElse("missing source file");
    }

    private String fileAsString(Optional<File> templateFile) {
        if (templateFile.isPresent()) {
            try {
                return FileUtils.readFileToString((File)templateFile.get());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "missing file:" + templateFile;
    }

    public static ExceptionInTemplate createExceptionInTemplate(SoySyntaxException e) {
        Optional<File> fileOpt = ExceptionInTemplate.createFile(e.getSourceLocation().getFilePath());
        Matcher matcher = PATTERN.matcher(e.getOriginalMessage());
        String viewName = e.getTemplateName();
        String message = e.getMessage();
        if (matcher.matches()) {
            Integer lineNo = Integer.parseInt(matcher.group(1).trim());
            Integer position = Integer.parseInt(matcher.group(2).trim());
            return new ExceptionInTemplate(fileOpt, viewName, lineNo, position, message, (Throwable)e);
        }
        return new ExceptionInTemplate(fileOpt, viewName, 0, 0, message, (Throwable)e);
    }

    private static Optional<File> createFile(String fileUri) {
        try {
            URL url = new URL(fileUri);
            return Optional.of(new File(url.toURI()));
        }
        catch (URISyntaxException ex) {
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

