/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.holder;

import com.github.mati1979.play.soyplugin.compile.EmptyTofuCompiler;
import com.github.mati1979.play.soyplugin.compile.TofuCompiler;
import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.holder.CompiledTemplatesHolder;
import com.github.mati1979.play.soyplugin.template.EmptyTemplateFilesResolver;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.github.mati1979.play.soyplugin.utils.Locks;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.template.soy.tofu.SoyTofu;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DefaultCompiledTemplatesHolder
implements CompiledTemplatesHolder {
    private static final Logger.ALogger logger = Logger.of(DefaultCompiledTemplatesHolder.class);
    private TofuCompiler tofuCompiler = new EmptyTofuCompiler();
    private TemplateFilesResolver templatesFileResolver = new EmptyTemplateFilesResolver();
    private Cache<String, SoyTofu> cache = CacheBuilder.newBuilder().build();
    private SoyViewConf soyViewConf = null;
    private static final String TEMPLATES_KEY = "templates";
    private ReentrantLock cacheLock = new ReentrantLock();

    public DefaultCompiledTemplatesHolder(TofuCompiler tofuCompiler, TemplateFilesResolver templatesFileResolver, SoyViewConf soyViewConf) throws IOException {
        this.tofuCompiler = tofuCompiler;
        this.templatesFileResolver = templatesFileResolver;
        this.soyViewConf = soyViewConf;
        this.cache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite((long)soyViewConf.globalHotReloadCompileTimeInSecs(), TimeUnit.SECONDS).build();
        this.init();
    }

    @Override
    public Optional<SoyTofu> compiledTemplates() throws IOException {
        if (this.shouldCompileTemplates()) {
            return Locks.withLock(this.cacheLock, () -> {
                Optional<Object> soyTofuOpt = Optional.ofNullable(this.cache.getIfPresent((Object)TEMPLATES_KEY));
                if (soyTofuOpt.isPresent()) {
                    return soyTofuOpt;
                }
                Stopwatch stopwatch = Stopwatch.createStarted();
                logger.debug("Compiling templates...");
                SoyTofu soyTofu = this.compileTemplates();
                this.cache.put((Object)TEMPLATES_KEY, (Object)soyTofu);
                stopwatch.stop();
                logger.info(String.format("Compiling templates, took: %d ms", stopwatch.elapsed(TimeUnit.MILLISECONDS)));
                return Optional.of(soyTofu);
            });
        }
        return Optional.ofNullable(this.cache.getIfPresent((Object)TEMPLATES_KEY));
    }

    private boolean shouldCompileTemplates() {
        return this.soyViewConf.globalHotReloadMode() || !Optional.ofNullable(this.cache.getIfPresent((Object)TEMPLATES_KEY)).isPresent();
    }

    public void init() throws IOException {
        logger.debug("TemplatesHolder init...");
        if (this.soyViewConf.compilePrecompileTemplates()) {
            logger.info("Precompilation of soy templates...");
            this.cache.put((Object)TEMPLATES_KEY, (Object)this.compileTemplates());
        }
    }

    private SoyTofu compileTemplates() throws IOException {
        Preconditions.checkNotNull((Object)this.templatesFileResolver, (Object)"templatesRenderer cannot be null!");
        Preconditions.checkNotNull((Object)this.tofuCompiler, (Object)"tofuCompiler cannot be null!");
        Collection<URL> templateFiles = this.templatesFileResolver.resolve();
        if (templateFiles.size() > 0) {
            logger.debug("Compiling templates, no:{}", new Object[]{templateFiles.size()});
            return this.tofuCompiler.compile(templateFiles);
        }
        throw new IOException("0 template files have been found, check your templateFilesResolver!");
    }
}

