/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.render;

import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.render.RenderRequest;
import com.github.mati1979.play.soyplugin.render.TemplateRenderer;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.tofu.SoyTofu;
import java.util.Optional;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DefaultTemplateRenderer
implements TemplateRenderer {
    private static final Logger.ALogger logger = Logger.of(DefaultTemplateRenderer.class);
    private SoyViewConf soyViewConf;

    public DefaultTemplateRenderer(SoyViewConf soyViewConf) {
        this.soyViewConf = soyViewConf;
    }

    @Override
    public String render(RenderRequest renderRequest) {
        SoyTofu compiledTemplates = renderRequest.getCompiledTemplates().get();
        String templateName = renderRequest.getTemplateName();
        logger.debug("rendering templateName:" + templateName);
        SoyTofu.Renderer renderer = compiledTemplates.newRenderer(templateName);
        Optional<SoyMapData> soyModel = renderRequest.getSoyModel();
        this.setupRenderer(renderer, renderRequest, soyModel);
        return renderer.render();
    }

    protected void setupRenderer(SoyTofu.Renderer renderer, RenderRequest renderRequest, Optional<SoyMapData> model) {
        Optional<SoyMsgBundle> soyMsgBundleOpt;
        Optional<SoyMapData> globalModel;
        if (model.isPresent()) {
            logger.debug("renderer - model is available.");
            renderer.setData(model.get());
        }
        if ((globalModel = renderRequest.getGlobalRuntimeModel()).isPresent()) {
            logger.debug("renderer - global runtime model is available.");
            renderer.setIjData(globalModel.get());
        }
        if ((soyMsgBundleOpt = renderRequest.getSoyMsgBundle()).isPresent()) {
            logger.debug("renderer - soyMsgBundle is available.");
            renderer.setMsgBundle(soyMsgBundleOpt.get());
            if (!this.soyViewConf.globalHotReloadMode() && renderRequest.getCompiledTemplates().isPresent()) {
                renderRequest.getCompiledTemplates().get().addToCache(soyMsgBundleOpt.get(), null);
            }
        }
        if (this.soyViewConf.globalHotReloadMode()) {
            renderer.setDontAddToCache(true);
        }
    }
}

