/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.ajax.config;

import com.github.mati1979.play.soyplugin.ajax.SoyAjaxController;
import com.github.mati1979.play.soyplugin.ajax.auth.AuthManager;
import com.github.mati1979.play.soyplugin.ajax.auth.ConfigurableAuthManager;
import com.github.mati1979.play.soyplugin.ajax.auth.PermissableAuthManager;
import com.github.mati1979.play.soyplugin.ajax.hash.HashFileGenerator;
import com.github.mati1979.play.soyplugin.ajax.hash.MD5HashFileGenerator;
import com.github.mati1979.play.soyplugin.ajax.process.OutputProcessor;
import com.github.mati1979.play.soyplugin.ajax.process.google.GoogleClosureOutputProcessor;
import com.github.mati1979.play.soyplugin.bundle.SoyMsgBundleResolver;
import com.github.mati1979.play.soyplugin.compile.TofuCompiler;
import com.github.mati1979.play.soyplugin.config.PlayConfAccessor;
import com.github.mati1979.play.soyplugin.locale.LocaleProvider;
import com.github.mati1979.play.soyplugin.spring.PlaySoyConfig;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.google.common.collect.Lists;
import java.util.Arrays;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import play.core.enhancers.PropertiesEnhancer;

@Configuration
@Import(value={PlaySoyConfig.class})
@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class PlaySoyViewAjaxConfig {
    @Bean
    public HashFileGenerator soyMd5HashFileGenerator() {
        MD5HashFileGenerator md5HashFileGenerator = new MD5HashFileGenerator();
        md5HashFileGenerator.setHotReloadMode(PlayConfAccessor.GLOBAL_HOT_RELOAD_MODE);
        return md5HashFileGenerator;
    }

    @Bean
    public SoyAjaxController soyAjaxController(AuthManager authManager, LocaleProvider localeProvider, TemplateFilesResolver templateFilesResolver, TofuCompiler tofuCompiler, SoyMsgBundleResolver soyMsgBundleResolver) {
        GoogleClosureOutputProcessor googleClosureOutputProcessor = new GoogleClosureOutputProcessor();
        googleClosureOutputProcessor.setEncoding(PlayConfAccessor.GLOBAL_ENCODING);
        SoyAjaxController soyAjaxController = new SoyAjaxController();
        soyAjaxController.setAuthManager(authManager);
        soyAjaxController.setEncoding(PlayConfAccessor.GLOBAL_ENCODING);
        soyAjaxController.setHotReloadMode(PlayConfAccessor.GLOBAL_HOT_RELOAD_MODE);
        soyAjaxController.setLocaleProvider(localeProvider);
        soyAjaxController.setOutputProcessors(Lists.newArrayList((Object[])new OutputProcessor[]{googleClosureOutputProcessor}));
        if (PlayConfAccessor.AJAX_CACHE_CONTROL != null && !PlayConfAccessor.AJAX_CACHE_CONTROL.isEmpty()) {
            soyAjaxController.setCacheControl(PlayConfAccessor.AJAX_CACHE_CONTROL);
        }
        soyAjaxController.setTemplateFilesResolver(templateFilesResolver);
        soyAjaxController.setTofuCompiler(tofuCompiler);
        soyAjaxController.setSoyMsgBundleResolver(soyMsgBundleResolver);
        if (PlayConfAccessor.AJAX_EXPIRE_HEADERS != null && !PlayConfAccessor.AJAX_EXPIRE_HEADERS.isEmpty()) {
            soyAjaxController.setExpireHeaders(PlayConfAccessor.AJAX_EXPIRE_HEADERS);
        }
        soyAjaxController.init();
        return soyAjaxController;
    }

    @Bean
    public AuthManager soyAuthManager() {
        if (PlayConfAccessor.AJAX_SECURITY_ENABLED && PlayConfAccessor.AJAX_ALLOWED_URLS != null && !PlayConfAccessor.AJAX_ALLOWED_URLS.isEmpty()) {
            String[] split = PlayConfAccessor.AJAX_ALLOWED_URLS.split(",");
            return new ConfigurableAuthManager(Arrays.asList(split));
        }
        return new PermissableAuthManager();
    }
}

