/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.render;

import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.render.RenderRequest;
import com.github.mati1979.play.soyplugin.render.TemplateRenderer;
import com.google.common.base.Optional;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.tofu.SoyTofu;
import play.Logger;

public class DefaultTemplateRenderer
implements TemplateRenderer {
    private SoyViewConf soyViewConf;
    private static final Logger.ALogger logger = Logger.of(DefaultTemplateRenderer.class);

    public DefaultTemplateRenderer(SoyViewConf soyViewConf) {
        this.soyViewConf = soyViewConf;
    }

    @Override
    public String render(RenderRequest renderRequest) throws Exception {
        SoyTofu compiledTemplates = (SoyTofu)renderRequest.getCompiledTemplates().get();
        String templateName = renderRequest.getTemplateName();
        SoyTofu.Renderer renderer = compiledTemplates.newRenderer(templateName);
        Optional<SoyMapData> soyModel = renderRequest.getSoyModel();
        this.setupRenderer(renderer, renderRequest, soyModel);
        return renderer.render();
    }

    protected void setupRenderer(SoyTofu.Renderer renderer, RenderRequest renderRequest, Optional<SoyMapData> model) throws Exception {
        Optional<SoyMsgBundle> soyMsgBundleOptional;
        Optional<SoyMapData> globalModel;
        if (model.isPresent()) {
            renderer.setData((SoyMapData)model.get());
        }
        if ((globalModel = renderRequest.getGlobalRuntimeModel()).isPresent()) {
            renderer.setIjData((SoyMapData)globalModel.get());
        }
        if ((soyMsgBundleOptional = renderRequest.getSoyMsgBundle()).isPresent()) {
            renderer.setMsgBundle((SoyMsgBundle)soyMsgBundleOptional.get());
            if (!this.soyViewConf.globalHotReloadMode() && renderRequest.getCompiledTemplates().isPresent()) {
                ((SoyTofu)renderRequest.getCompiledTemplates().get()).addToCache((SoyMsgBundle)soyMsgBundleOptional.get(), null);
            }
        }
        if (this.soyViewConf.globalHotReloadMode()) {
            renderer.setDontAddToCache(true);
        }
    }
}

