/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.template;

import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import play.Logger;
import play.Play;

@ThreadSafe
public class FileSystemTemplateFilesResolver
implements TemplateFilesResolver {
    private static final Logger.ALogger logger = Logger.of(FileSystemTemplateFilesResolver.class);
    CopyOnWriteArrayList<URL> cachedFiles = new CopyOnWriteArrayList();
    private SoyViewConf soyViewConf;

    public FileSystemTemplateFilesResolver(SoyViewConf soyViewConf) {
        this.soyViewConf = soyViewConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<URL> resolve() throws IOException {
        Preconditions.checkNotNull((Object)this.soyViewConf.resolveTemplatesLocation(), (Object)"templatesLocation cannot be null!");
        if (this.soyViewConf.globalHotReloadMode()) {
            List<URL> files = this.toFiles(this.soyViewConf.resolveTemplatesLocation());
            logger.debug("Debug on - resolved files:" + files.size());
            return files;
        }
        CopyOnWriteArrayList<URL> copyOnWriteArrayList = this.cachedFiles;
        synchronized (copyOnWriteArrayList) {
            if (this.cachedFiles.isEmpty()) {
                List<URL> files = this.toFiles(this.soyViewConf.resolveTemplatesLocation());
                logger.debug("templates location:" + this.soyViewConf.resolveTemplatesLocation());
                logger.debug("Using cache resolve, debug off, urls:" + files.size());
                this.cachedFiles.addAll(files);
            }
        }
        return this.cachedFiles;
    }

    @Override
    public Optional<URL> resolve(final @Nullable String templateFileName) throws IOException {
        if (templateFileName == null) {
            return Optional.absent();
        }
        Collection<URL> files = this.resolve();
        URL templateFile = (URL)Iterables.find(files, (Predicate)new Predicate<URL>(){

            public boolean apply(URL url) {
                String fileName = url.getFile();
                File file = new File(fileName);
                return file.toURI().toString().endsWith(FileSystemTemplateFilesResolver.this.normalizeTemplateName(templateFileName));
            }
        }, null);
        return Optional.fromNullable((Object)templateFile);
    }

    private String normalizeTemplateName(String templateFileName) {
        String normalizedTemplateName = templateFileName;
        if (!templateFileName.endsWith(this.dotWithExtension())) {
            normalizedTemplateName = templateFileName + this.dotWithExtension();
        }
        return normalizedTemplateName;
    }

    private List<URL> toFiles(String templatesLocation) {
        ArrayList templateFiles = Lists.newArrayList();
        try {
            File baseDirectory = Play.application().getFile(templatesLocation);
            if (!baseDirectory.isDirectory()) {
                throw new IllegalArgumentException("Soy template base directory:" + templatesLocation + "' is not a directory");
            }
            templateFiles.addAll(this.findSoyFiles(baseDirectory, this.soyViewConf.resolveRecursive()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error with soy template base directory:" + templatesLocation, e);
        }
        return templateFiles;
    }

    protected List<URL> findSoyFiles(File baseDirectory, boolean recursive) throws MalformedURLException {
        ArrayList<URL> soyFiles = new ArrayList<URL>();
        this.findSoyFiles(soyFiles, baseDirectory, recursive);
        return soyFiles;
    }

    protected void findSoyFiles(List<URL> soyFiles, File baseDirectory, boolean recursive) throws MalformedURLException {
        File[] files = baseDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    if (!file.getName().endsWith(this.dotWithExtension())) continue;
                    soyFiles.add(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory() || !recursive) continue;
                this.findSoyFiles(soyFiles, file, recursive);
            }
        } else {
            throw new IllegalArgumentException("Unable to retrieve contents of:" + baseDirectory);
        }
    }

    private String dotWithExtension() {
        return "." + this.soyViewConf.resolveFilesExtension();
    }
}

