/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.holder;

import com.github.mati1979.play.soyplugin.compile.EmptyTofuCompiler;
import com.github.mati1979.play.soyplugin.compile.TofuCompiler;
import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.holder.CompiledTemplatesHolder;
import com.github.mati1979.play.soyplugin.template.EmptyTemplateFilesResolver;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.template.soy.tofu.SoyTofu;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DefaultCompiledTemplatesHolder
implements CompiledTemplatesHolder {
    private static final Logger.ALogger logger = Logger.of(DefaultCompiledTemplatesHolder.class);
    private TofuCompiler tofuCompiler = new EmptyTofuCompiler();
    private TemplateFilesResolver templatesFileResolver = new EmptyTemplateFilesResolver();
    private Optional<SoyTofu> compiledTemplates = Optional.absent();
    private SoyViewConf soyViewConf = null;

    public DefaultCompiledTemplatesHolder(TofuCompiler tofuCompiler, TemplateFilesResolver templatesFileResolver, SoyViewConf soyViewConf) throws IOException {
        this.tofuCompiler = tofuCompiler;
        this.templatesFileResolver = templatesFileResolver;
        this.soyViewConf = soyViewConf;
        this.init();
    }

    @Override
    public Optional<SoyTofu> compiledTemplates() throws IOException {
        if (this.shouldCompileTemplates()) {
            this.compiledTemplates = Optional.fromNullable((Object)this.compileTemplates());
        }
        return this.compiledTemplates;
    }

    private boolean shouldCompileTemplates() {
        return this.soyViewConf.globalHotReloadMode() || !this.compiledTemplates.isPresent();
    }

    public void init() throws IOException {
        logger.debug("TemplatesHolder init...");
        if (this.soyViewConf.compilePrecompileTemplates()) {
            this.compiledTemplates = Optional.fromNullable((Object)this.compileTemplates());
        }
    }

    private SoyTofu compileTemplates() throws IOException {
        Preconditions.checkNotNull((Object)this.templatesFileResolver, (Object)"templatesRenderer cannot be null!");
        Preconditions.checkNotNull((Object)this.tofuCompiler, (Object)"tofuCompiler cannot be null!");
        Collection<URL> templateFiles = this.templatesFileResolver.resolve();
        if (templateFiles.size() > 0) {
            logger.debug("Compiling templates, no:{}", new Object[]{templateFiles.size()});
            return this.tofuCompiler.compile(templateFiles);
        }
        throw new IOException("0 template files have been found, check your templateFilesResolver!");
    }
}

