/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.ajax.allowedurls;

import com.github.mati1979.play.soyplugin.ajax.allowedurls.SoyAllowedUrls;
import com.github.mati1979.play.soyplugin.ajax.allowedurls.SoyAllowedUrlsResolver;
import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DefaultSoyAllowedUrlsResolver
implements SoyAllowedUrlsResolver {
    private final TemplateFilesResolver templateFilesResolver;
    private final SoyViewConf soyViewConf;

    public DefaultSoyAllowedUrlsResolver(TemplateFilesResolver templateFilesResolver, SoyViewConf soyViewConf) {
        this.templateFilesResolver = templateFilesResolver;
        this.soyViewConf = soyViewConf;
    }

    @Override
    public SoyAllowedUrls allowedUrls() {
        List<String> templateNames = Arrays.asList(this.soyViewConf.ajaxAllowedUrls().split(","));
        final Map<String, Supplier<Optional<URL>>> cache = this.urlsCache(this.templateFilesResolver, templateNames);
        ImmutableList urls = FluentIterable.from(templateNames).filter((Predicate)new Predicate<String>(){

            public boolean apply(String templateName) {
                return ((Optional)((Supplier)cache.get(templateName)).get()).isPresent();
            }
        }).transform((Function)new Function<String, URL>(){

            public URL apply(String templateName) {
                return (URL)((Optional)((Supplier)cache.get(templateName)).get()).get();
            }
        }).toList();
        return new SoyAllowedUrls((List<URL>)urls, templateNames, this.soyViewConf.ajaxSecurityEnabled());
    }

    private Map<String, Supplier<Optional<URL>>> urlsCache(final TemplateFilesResolver templateFilesResolver, List<String> templateNames) {
        HashMap<String, Supplier<Optional<URL>>> cache = new HashMap<String, Supplier<Optional<URL>>>();
        for (final String templateName : templateNames) {
            Supplier memoize = Suppliers.memoize((Supplier)new Supplier<Optional<URL>>(){

                public Optional<URL> get() {
                    try {
                        return templateFilesResolver.resolve(templateName);
                    }
                    catch (IOException e) {
                        return Optional.absent();
                    }
                }
            });
            cache.put(templateName, (Supplier<Optional<URL>>)memoize);
        }
        return cache;
    }
}

