/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.plugin;

import com.github.mati1979.play.soyplugin.ajax.config.PlaySoyViewAjaxConfig;
import com.github.mati1979.play.soyplugin.spring.PlaySoyConfig;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import play.Application;
import play.Plugin;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ClosurePlugin
extends Plugin {
    private AnnotationConfigApplicationContext ctx;
    private Application app;

    public ClosurePlugin(Application app) {
        this.app = app;
    }

    public void onStart() {
        if (this.isAdvancedMode()) {
            this.ctx = new AnnotationConfigApplicationContext(new Class[]{PlaySoyViewAjaxConfig.class});
            this.ctx.registerBeanDefinition("playApp", (BeanDefinition)new GenericBeanDefinition());
        }
        if (this.isSimpleMode()) {
            this.ctx = new AnnotationConfigApplicationContext(new Class[]{PlaySoyConfig.class});
        }
    }

    private boolean isAdvancedMode() {
        String type = this.app.configuration().getString("ClosurePlugin.mode", "simple");
        return !type.equals("advanced");
    }

    private boolean isSimpleMode() {
        String type = this.app.configuration().getString("ClosurePlugin.mode", "simple");
        return !type.equals("simple");
    }

    public ApplicationContext getContext() {
        return this.ctx;
    }

    public boolean enabled() {
        return this.app.configuration().getBoolean("ClosurePlugin.enabled", Boolean.valueOf(true));
    }
}

