/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.bundle;

import com.github.mati1979.play.soyplugin.bundle.SoyMsgBundleResolver;
import com.github.mati1979.play.soyplugin.config.SoyViewConf;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.SoyMsgPlugin;
import com.google.template.soy.msgs.restricted.SoyMsgBundleImpl;
import com.google.template.soy.xliffmsgplugin.XliffMsgPlugin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class DefaultSoyMsgBundleResolver
implements SoyMsgBundleResolver {
    private static final Logger.ALogger logger = Logger.of(DefaultSoyMsgBundleResolver.class);
    Map<Locale, SoyMsgBundle> msgBundles = new ConcurrentHashMap<Locale, SoyMsgBundle>();
    private SoyViewConf soyViewConf = null;

    public DefaultSoyMsgBundleResolver(SoyViewConf soyViewConf) {
        this.soyViewConf = soyViewConf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<SoyMsgBundle> resolve(Optional<Locale> locale) throws IOException {
        if (!locale.isPresent()) {
            return Optional.absent();
        }
        Map<Locale, SoyMsgBundle> map = this.msgBundles;
        synchronized (map) {
            SoyMsgBundle soyMsgBundle = null;
            if (!this.soyViewConf.globalHotReloadMode()) {
                soyMsgBundle = this.msgBundles.get(locale.get());
            }
            if (soyMsgBundle == null) {
                soyMsgBundle = this.createSoyMsgBundle((Locale)locale.get());
                if (soyMsgBundle == null) {
                    soyMsgBundle = this.createSoyMsgBundle(new Locale(((Locale)locale.get()).getLanguage()));
                }
                if (soyMsgBundle == null && this.soyViewConf.i18nFallbackToEnglish()) {
                    soyMsgBundle = this.createSoyMsgBundle(Locale.ENGLISH);
                }
                if (soyMsgBundle == null) {
                    return Optional.absent();
                }
                if (!this.soyViewConf.globalHotReloadMode()) {
                    this.msgBundles.put((Locale)locale.get(), soyMsgBundle);
                }
            }
            return Optional.fromNullable(soyMsgBundle);
        }
    }

    protected SoyMsgBundle createSoyMsgBundle(Locale locale) throws IOException {
        Preconditions.checkNotNull((Object)this.soyViewConf.i18nMessagesPath(), (Object)"messagesPath cannot be null!");
        String path2 = this.soyViewConf.i18nMessagesPath() + "_" + locale.toString() + ".xlf";
        ArrayList msgBundles = Lists.newArrayList();
        File file = Play.application().getFile(path2);
        SoyMsgBundleHandler msgBundleHandler = new SoyMsgBundleHandler((SoyMsgPlugin)new XliffMsgPlugin());
        if (file.exists()) {
            SoyMsgBundle soyMsgBundle = msgBundleHandler.createFromFile(file);
            msgBundles.add(soyMsgBundle);
        }
        return (SoyMsgBundle)this.mergeMsgBundles(locale, msgBundles).orNull();
    }

    private Optional<? extends SoyMsgBundle> mergeMsgBundles(Locale locale, List<SoyMsgBundle> soyMsgBundles) {
        if (soyMsgBundles.isEmpty()) {
            return Optional.absent();
        }
        ArrayList msgs = Lists.newArrayList();
        for (SoyMsgBundle smb : soyMsgBundles) {
            Iterator it = smb.iterator();
            while (it.hasNext()) {
                msgs.add(it.next());
            }
        }
        return Optional.of((Object)new SoyMsgBundleImpl(locale.toString(), (List)msgs));
    }
}

