/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.data;

import com.github.mati1979.play.soyplugin.data.ToSoyDataConverter;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.primitives.Primitives;
import com.google.template.soy.data.SoyMapData;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class ReflectionToSoyDataConverter
implements ToSoyDataConverter {
    @Override
    public Optional<SoyMapData> toSoyMap(Object model) {
        if (model == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)this.objectToSoyDataMap(model));
    }

    private Map<String, ?> toSoyCompatibleMap(Object obj) {
        Object ret = this.toSoyCompatibleObjects(obj);
        if (!(ret instanceof Map)) {
            throw new IllegalArgumentException("Input should be a Map or POJO.");
        }
        return (Map)ret;
    }

    private Object toSoyCompatibleObjects(Object obj) {
        if (obj == null) {
            return obj;
        }
        if (Primitives.isWrapperType(obj.getClass()) || obj.getClass().isPrimitive() || obj instanceof String) {
            return obj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            HashMap<String, Object> newMap = new HashMap<String, Object>(map.size());
            for (String key : map.keySet()) {
                newMap.put(key, this.toSoyCompatibleObjects(map.get(key)));
            }
            return newMap;
        }
        if (obj instanceof Iterable) {
            ArrayList list = Lists.newArrayList();
            for (Object subValue : (Iterable)obj) {
                list.add(this.toSoyCompatibleObjects(subValue));
            }
            return list;
        }
        if (obj.getClass().isArray()) {
            return obj;
        }
        Map<String, ?> pojoMap = ReflectionToSoyDataConverter.pojoToMap(obj);
        HashMap<String, Object> newMap = new HashMap<String, Object>(pojoMap.size());
        for (String key : pojoMap.keySet()) {
            newMap.put(key, this.toSoyCompatibleObjects(pojoMap.get(key)));
        }
        return newMap;
    }

    private static Map<String, ?> pojoToMap(Object pojo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(pojo.getClass());
            for (PropertyDescriptor pd : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                if (pd.getReadMethod() == null || "class".equals(pd.getName())) continue;
                map.put(pd.getName(), pd.getReadMethod().invoke(pojo, new Object[0]));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private SoyMapData objectToSoyDataMap(Object obj) {
        if (obj == null) {
            return new SoyMapData();
        }
        if (obj instanceof SoyMapData) {
            return (SoyMapData)obj;
        }
        return new SoyMapData(this.toSoyCompatibleMap(obj));
    }
}

