/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.ajax.hash;

import com.github.mati1979.play.soyplugin.ajax.hash.HashFileGenerator;
import com.github.mati1979.play.soyplugin.config.PlayConfAccessor;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.input.ReaderInputStream;
import play.Logger;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class MD5HashFileGenerator
implements HashFileGenerator {
    private static final Logger.ALogger logger = Logger.of(MD5HashFileGenerator.class);
    private boolean hotReloadMode = PlayConfAccessor.GLOBAL_HOT_RELOAD_MODE;
    private static final int DEF_CACHE_MAX_SIZE = 10000;
    private static final String DEF_TIME_UNIT = "DAYS";
    private static final int DEF_EXPIRE_AFTER_WRITE = 1;
    private int cacheMaxSize = 10000;
    private int expireAfterWrite = 1;
    private String expireAfterWriteUnit = "DAYS";
    Cache<URL, String> cache = CacheBuilder.newBuilder().expireAfterWrite((long)this.expireAfterWrite, TimeUnit.valueOf(this.expireAfterWriteUnit)).maximumSize((long)this.cacheMaxSize).concurrencyLevel(1).build();

    public MD5HashFileGenerator() {
        this.init();
    }

    public void init() {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite((long)this.expireAfterWrite, TimeUnit.valueOf(this.expireAfterWriteUnit)).maximumSize((long)this.cacheMaxSize).concurrencyLevel(1).build();
    }

    @Override
    public Optional<String> hash(Optional<URL> url) throws IOException {
        if (!url.isPresent()) {
            return Optional.absent();
        }
        logger.debug("Calculating md5 hash, url:{}", new Object[]{url});
        if (this.isHotReloadModeOff()) {
            String md5 = (String)this.cache.getIfPresent(url.get());
            logger.debug("md5 hash:{}", new Object[]{md5});
            if (md5 != null) {
                return Optional.of((Object)md5);
            }
        }
        InputStream is = ((URL)url.get()).openStream();
        String md5 = MD5HashFileGenerator.getMD5Checksum(is);
        if (this.isHotReloadModeOff()) {
            logger.debug("caching url:{} with hash:{}", new Object[]{url, md5});
            this.cache.put(url.get(), (Object)md5);
        }
        return Optional.fromNullable((Object)md5);
    }

    @Override
    public Optional<String> hashMulti(Collection<URL> urls) throws IOException {
        if (urls.isEmpty()) {
            return Optional.absent();
        }
        if (urls.size() == 1) {
            return this.hash((Optional<URL>)Optional.of((Object)urls.iterator().next()));
        }
        ArrayList<Object> hashes = new ArrayList<Object>();
        for (URL url : urls) {
            Optional<String> optional = this.hash((Optional<URL>)Optional.of((Object)url));
            if (!optional.isPresent()) continue;
            hashes.add(optional.get());
        }
        StringBuilder builder = new StringBuilder();
        for (String string : hashes) {
            builder.append(string);
        }
        return Optional.fromNullable((Object)MD5HashFileGenerator.getMD5Checksum((InputStream)new ReaderInputStream((Reader)new StringReader(builder.toString()))));
    }

    public static String getMD5Checksum(InputStream is) throws IOException {
        HashFunction hf = Hashing.md5();
        HashCode hashCode = hf.hashBytes(MD5HashFileGenerator.getBytesFromInputStream(is));
        return hashCode.toString();
    }

    private static byte[] getBytesFromInputStream(InputStream inStream) throws IOException {
        int offset;
        long streamLength = inStream.available();
        if (streamLength > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)streamLength];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = inStream.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file ");
        }
        inStream.close();
        return bytes;
    }

    public void setHotReloadMode(boolean hotReloadMode) {
        this.hotReloadMode = hotReloadMode;
    }

    public void setCacheMaxSize(int cacheMaxSize) {
        this.cacheMaxSize = cacheMaxSize;
    }

    public void setExpireAfterWrite(int expireAfterWrite) {
        this.expireAfterWrite = expireAfterWrite;
    }

    public void setExpireAfterWriteUnit(String expireAfterWriteUnit) {
        this.expireAfterWriteUnit = expireAfterWriteUnit;
    }

    private boolean isHotReloadModeOff() {
        return !this.hotReloadMode;
    }

    public boolean isHotReloadMode() {
        return this.hotReloadMode;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public int getExpireAfterWrite() {
        return this.expireAfterWrite;
    }

    public String getExpireAfterWriteUnit() {
        return this.expireAfterWriteUnit;
    }
}

