/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.ajax.runtime;

import com.github.mati1979.play.soyplugin.ajax.hash.HashFileGenerator;
import com.github.mati1979.play.soyplugin.config.PlayConfAccessor;
import com.github.mati1979.play.soyplugin.global.runtime.RuntimeDataResolver;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.FluentIterable;
import com.google.template.soy.data.SoyMapData;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import play.core.enhancers.PropertiesEnhancer;
import play.mvc.Http;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
public class SoyHashesRuntimeDataResolver
implements RuntimeDataResolver {
    private HashFileGenerator hashFileGenerator;
    private TemplateFilesResolver templateFilesResolver;
    private String ajaxAllowedUrls = PlayConfAccessor.AJAX_ALLOWED_URLS;

    public SoyHashesRuntimeDataResolver(HashFileGenerator hashFileGenerator, TemplateFilesResolver templateFilesResolver) {
        this.hashFileGenerator = hashFileGenerator;
        this.templateFilesResolver = templateFilesResolver;
    }

    public SoyHashesRuntimeDataResolver() {
    }

    public void resolveData(Http.Request request, Http.Response response, Map<String, ?> model, SoyMapData root) {
        try {
            root.put("soyplugin.ajax.soy.hash", (String)this.hashFileGenerator.hashMulti(this.urls()).or((Object)""));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<URL> urls() {
        List<String> templateNames = Arrays.asList(this.ajaxAllowedUrls.split(","));
        final Map<String, Supplier<Optional<URL>>> cache = this.urlsCache(templateNames);
        return FluentIterable.from(templateNames).filter((Predicate)new Predicate<String>(){

            public boolean apply(String templateName) {
                return ((Optional)((Supplier)cache.get(templateName)).get()).isPresent();
            }
        }).transform((Function)new Function<String, URL>(){

            public URL apply(String templateName) {
                return (URL)((Optional)((Supplier)cache.get(templateName)).get()).get();
            }
        }).toList();
    }

    private Map<String, Supplier<Optional<URL>>> urlsCache(List<String> templateNames) {
        HashMap<String, Supplier<Optional<URL>>> cache = new HashMap<String, Supplier<Optional<URL>>>();
        for (final String templateName : templateNames) {
            Supplier memoize = Suppliers.memoize((Supplier)new Supplier<Optional<URL>>(){

                public Optional<URL> get() {
                    try {
                        return SoyHashesRuntimeDataResolver.this.templateFilesResolver.resolve(templateName);
                    }
                    catch (IOException e) {
                        return Optional.absent();
                    }
                }
            });
            cache.put(templateName, (Supplier<Optional<URL>>)memoize);
        }
        return cache;
    }

    public void setHashFileGenerator(HashFileGenerator hashFileGenerator) {
        this.hashFileGenerator = hashFileGenerator;
    }

    public void setTemplateFilesResolver(TemplateFilesResolver templateFilesResolver) {
        this.templateFilesResolver = templateFilesResolver;
    }

    public void setAjaxAllowedUrls(String ajaxAllowedUrls) {
        this.ajaxAllowedUrls = ajaxAllowedUrls;
    }
}

