/*
 * Decompiled with CFR 0.152.
 */
package com.github.mati1979.play.soyplugin.template;

import com.github.mati1979.play.soyplugin.config.PlayConfAccessor;
import com.github.mati1979.play.soyplugin.template.TemplateFilesResolver;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import play.Logger;
import play.Play;
import play.core.enhancers.PropertiesEnhancer;

@PropertiesEnhancer.GeneratedAccessor
@PropertiesEnhancer.RewrittenAccessor
@ThreadSafe
public class DefaultTemplateFilesResolver
implements TemplateFilesResolver {
    private static final Logger.ALogger logger = Logger.of(DefaultTemplateFilesResolver.class);
    private String templatesLocation = PlayConfAccessor.COMPILE_TEMPLATES_LOCATION;
    private boolean recursive = PlayConfAccessor.COMPILE_RECURSIVE;
    private boolean hotReloadMode = PlayConfAccessor.GLOBAL_HOT_RELOAD_MODE;
    CopyOnWriteArrayList<URL> cachedFiles = new CopyOnWriteArrayList();
    private String filesExtension = PlayConfAccessor.COMPILE_FILES_EXTENSION;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<URL> resolve() throws IOException {
        Preconditions.checkNotNull((Object)this.templatesLocation, (Object)"templatesLocation cannot be null!");
        if (this.hotReloadMode) {
            List<URL> files = this.toFiles(this.templatesLocation);
            logger.debug("Debug on - resolved files:" + files.size());
            return files;
        }
        CopyOnWriteArrayList<URL> copyOnWriteArrayList = this.cachedFiles;
        synchronized (copyOnWriteArrayList) {
            if (this.cachedFiles.isEmpty()) {
                List<URL> files = this.toFiles(this.templatesLocation);
                logger.debug("templates location:" + this.templatesLocation);
                logger.debug("Using cache resolve, debug off, urls:" + files.size());
                this.cachedFiles.addAll(files);
            }
        }
        return this.cachedFiles;
    }

    @Override
    public Optional<URL> resolve(final @Nullable String templateFileName) throws IOException {
        if (templateFileName == null) {
            return Optional.absent();
        }
        Collection<URL> files = this.resolve();
        URL templateFile = (URL)Iterables.find(files, (Predicate)new Predicate<URL>(){

            public boolean apply(URL url) {
                String fileName = url.getFile();
                File file = new File(fileName);
                return file.toURI().toString().endsWith(DefaultTemplateFilesResolver.this.normalizeTemplateName(templateFileName));
            }
        }, null);
        return Optional.fromNullable((Object)templateFile);
    }

    private String normalizeTemplateName(String templateFileName) {
        String normalizedTemplateName = templateFileName;
        if (!templateFileName.endsWith(this.dotWithExtension())) {
            normalizedTemplateName = templateFileName + this.dotWithExtension();
        }
        return normalizedTemplateName;
    }

    private List<URL> toFiles(String templatesLocation) {
        ArrayList templateFiles = Lists.newArrayList();
        try {
            File baseDirectory = Play.application().getFile(templatesLocation);
            if (!baseDirectory.isDirectory()) {
                throw new IllegalArgumentException("Soy template base directory:" + templatesLocation + "' is not a directory");
            }
            templateFiles.addAll(this.findSoyFiles(baseDirectory, this.recursive));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error with soy template base directory:" + templatesLocation, e);
        }
        return templateFiles;
    }

    protected List<URL> findSoyFiles(File baseDirectory, boolean recursive) throws MalformedURLException {
        ArrayList<URL> soyFiles = new ArrayList<URL>();
        this.findSoyFiles(soyFiles, baseDirectory, recursive);
        return soyFiles;
    }

    protected void findSoyFiles(List<URL> soyFiles, File baseDirectory, boolean recursive) throws MalformedURLException {
        File[] files = baseDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    if (!file.getName().endsWith(this.dotWithExtension())) continue;
                    soyFiles.add(file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory() || !recursive) continue;
                this.findSoyFiles(soyFiles, file, recursive);
            }
        } else {
            throw new IllegalArgumentException("Unable to retrieve contents of:" + baseDirectory);
        }
    }

    private String dotWithExtension() {
        return "." + this.filesExtension;
    }

    public void setTemplatesLocation(String templatesLocation) {
        this.templatesLocation = templatesLocation;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    public void setHotReloadMode(boolean hotReloadMode) {
        this.hotReloadMode = hotReloadMode;
    }

    public String getTemplatesLocation() {
        return this.templatesLocation;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public boolean isHotReloadMode() {
        return this.hotReloadMode;
    }

    public String getFilesExtension() {
        return this.filesExtension;
    }

    public void setFilesExtension(String filesExtension) {
        this.filesExtension = filesExtension;
    }
}

